#include <stdlib.h>
#include <math.h>
#include <omp.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>

void timer_clear(int n);
void timer_start(int n);
void timer_stop(int n);
double timer_read(int n);
enum NAS_BT_B_c_16690 { false, true };
typedef enum NAS_BT_B_c_16690 logical;
struct named_NAS_BT_B_c_16704
{
	double real;
	double imag;
};

typedef struct named_NAS_BT_B_c_16704 dcomplex;
int grid_points[3];
logical timeron;
double tx1, tx2, tx3, ty1, ty2, ty3, tz1, tz2, tz3, dx1, dx2, dx3, dx4, dx5, dy1, dy2, dy3, dy4, dy5, dz1, dz2, dz3, dz4, dz5, dssp, dt, ce[5][13], dxmax, dymax, dzmax, xxcon1, xxcon2, xxcon3, xxcon4, xxcon5, dx1tx1, dx2tx1, dx3tx1, dx4tx1, dx5tx1, yycon1, yycon2, yycon3, yycon4, yycon5, dy1ty1, dy2ty1, dy3ty1, dy4ty1, dy5ty1, zzcon1, zzcon2, zzcon3, zzcon4, zzcon5, dz1tz1, dz2tz1, dz3tz1, dz4tz1, dz5tz1, dnxm1, dnym1, dnzm1, c1c2, c1c5, c3c4, c1345, conz1, c1, c2, c3, c4, c5, c4dssp, c5dssp, dtdssp, dttx1, dttx2, dtty1, dtty2, dttz1, dttz2, c2dttx1, c2dtty1, c2dttz1, comz1, comz4, comz5, comz6, c3c4tx3, c3c4ty3, c3c4tz3, c2iv, con43, con16;
double us[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double vs[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double ws[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double qs[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double rho_i[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double square[102][(((102/2)*2)+1)][(((102/2)*2)+1)];
double forcing[102][(((102/2)*2)+1)][(((102/2)*2)+1)][5];
double u[102][(((102/2)*2)+1)][(((102/2)*2)+1)][5];
double rhs[102][(((102/2)*2)+1)][(((102/2)*2)+1)][5];
double cuf[(102+1)];
double q[(102+1)];
double ue[(102+1)][5];
double buf[(102+1)][5];
double fjac[(102+1)][5][5];
double njac[(102+1)][5][5];
double lhs[(102+1)][3][5][5];
double tmp1, tmp2, tmp3;
void initialize();
void lhsinit(double lhs[][3][5][5], int size);
void exact_solution(double xi, double eta, double zeta, double dtemp[5]);
void exact_rhs();
void set_constants();
void adi();
void compute_rhs();
void x_solve();
void y_solve();
void matvec_sub(double ablock[5][5], double avec[5], double bvec[5]);
void matmul_sub(double ablock[5][5], double bblock[5][5], double cblock[5][5]);
void binvcrhs(double lhs[5][5], double c[5][5], double r[5]);
void binvrhs(double lhs[5][5], double r[5]);
void z_solve();
void add();
void error_norm(double rms[5]);
void rhs_norm(double rms[5]);
void verify(int no_time_steps, char * class, logical * verified);
void wtime_(double * );
static double elapsed_time(void );
int main(int argc, char * argv[])
{
	omp_set_num_threads(4);
	int i, niter, step;
	double navg, mflops, n3;
	double tmax, t, trecs[(11+1)];
	logical verified;
	char Class;
	char * t_names[(11+1)];
	FILE * fp;
	int _ret_val_0;
	if ((fp=fopen("timer.flag", "r"))!=((void * )0))
	{
		timeron=true;
		t_names[1]="total";
		t_names[2]="rhsx";
		t_names[3]="rhsy";
		t_names[4]="rhsz";
		t_names[5]="rhs";
		t_names[6]="xsolve";
		t_names[7]="ysolve";
		t_names[8]="zsolve";
		t_names[9]="redist1";
		t_names[10]="redist2";
		t_names[11]="add";
		fclose(fp);
	}
	else
	{
		timeron=false;
	}
	printf("\n\n NAS Parallel Benchmarks (NPB3.3-SER-C) - BT Benchmark\n\n");
	if ((fp=fopen("inputbt.data", "r"))!=((void * )0))
	{
		int result;
		printf(" Reading from input file inputbt.data\n");
		result=fscanf(fp, "%d",  & niter);
		while (fgetc(fp)!='\n')
		{
			;
		}
		result=fscanf(fp, "%lf",  & dt);
		while (fgetc(fp)!='\n')
		{
			;
		}
		result=fscanf(fp, "%d%d%d\n",  & grid_points[0],  & grid_points[1],  & grid_points[2]);
		fclose(fp);
	}
	else
	{
		printf(" No input file inputbt.data. Using compiled defaults\n");
		niter=200;
		dt=3.0E-4;
		grid_points[0]=102;
		grid_points[1]=102;
		grid_points[2]=102;
	}
	printf(" Size: %4dx%4dx%4d\n", grid_points[0], grid_points[1], grid_points[2]);
	printf(" Iterations: %4d    dt: %10.6f\n", niter, dt);
	printf("\n");
	if (((grid_points[0]>102)||(grid_points[1]>102))||(grid_points[2]>102))
	{
		printf(" %d, %d, %d\n", grid_points[0], grid_points[1], grid_points[2]);
		printf(" Problem size too big for compiled array sizes\n");
		_ret_val_0=0;
		return _ret_val_0;
	}
	set_constants();
	//#pragma cetus private(i)
	#pragma loop name main#0
	for (i=1; i<=11; i ++ )
	{
		timer_clear(i);
	}
	initialize();
	exact_rhs();
	adi();
	initialize();
	//#pragma cetus private(i)
	#pragma loop name main#1
	for (i=1; i<=11; i ++ )
	{
		timer_clear(i);
	}
	timer_start(1);
	//#pragma cetus private(step)
	#pragma loop name main#2
	for (step=1; step<=niter; step ++ )
	{
		if (((step%20)==0)||(step==1))
		{
			printf(" Time step %4d\n", step);
		}
		adi();
	}
	timer_stop(1);
	tmax=timer_read(1);
	verify(niter,  & Class,  & verified);
	n3=(((1.0*grid_points[0])*grid_points[1])*grid_points[2]);
	navg=(((grid_points[0]+grid_points[1])+grid_points[2])/3.0);
	if (tmax!=0.0)
	{
		mflops=(((1.0E-6*((double)niter))*(((3478.8*n3)-(17655.7*(navg*navg)))+(28023.7*navg)))/tmax);
	}
	else
	{
		mflops=0.0;
	}
	print_results("BT", Class, grid_points[0], grid_points[1], grid_points[2], niter, tmax, mflops, "          floating point", verified, "3.3.1", "05 Nov 2022", "gcc", "$(CC)", "-lm", "-I../common", "-g -Wall -O3 -mcmodel=medium", "-O3 -mcmodel=medium", "(none)");
	if (timeron)
	{
		//#pragma cetus private(i)
		#pragma loop name main#3
		for (i=1; i<=11; i ++ )
		{
			trecs[i]=timer_read(i);
		}
		if (tmax==0.0)
		{
			tmax=1.0;
		}
		printf("  SECTION   Time (secs)\n");
		//#pragma cetus private(i, t)
		#pragma loop name main#4
		for (i=1; i<=11; i ++ )
		{
			printf("  %-8s:%9.3f  (%6.2f%%)\n", t_names[i], trecs[i], (trecs[i]*100.0)/tmax);
			if (i==5)
			{
				t=((trecs[2]+trecs[3])+trecs[4]);
				printf("    --> %8s:%9.3f  (%6.2f%%)\n", "sub-rhs", t, (t*100.0)/tmax);
				t=(trecs[5]-t);
				printf("    --> %8s:%9.3f  (%6.2f%%)\n", "rest-rhs", t, (t*100.0)/tmax);
			}
			else
			{
				if (i==8)
				{
					t=((trecs[8]-trecs[9])-trecs[10]);
					printf("    --> %8s:%9.3f  (%6.2f%%)\n", "sub-zsol", t, (t*100.0)/tmax);
				}
				else
				{
					if (i==10)
					{
						t=(trecs[9]+trecs[10]);
						printf("    --> %8s:%9.3f  (%6.2f%%)\n", "redist", t, (t*100.0)/tmax);
					}
				}
			}
		}
	}
	_ret_val_0=0;
	return _ret_val_0;
}

void initialize()
{
	int i, j, k, m, ix, iy, iz;
	double xi, eta, zeta, Pface[2][3][5], Pxi, Peta, Pzeta, temp[5];


	//#pragma cetus private(i, j, k, m)
	#pragma loop name initialize#0
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name initialize#0#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name initialize#0#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name initialize#0#0#0#0
				for (m=0; m<5; m ++ )
				{
					u[k][j][i][m]=1.0;
				}
			}
		}
	}
	//#pragma cetus private(Peta, Pxi, Pzeta, eta, i, ix, iy, iz, j, k, m, xi, zeta)
	#pragma loop name initialize#1
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(Peta, Pxi, Pzeta, eta, i, ix, iy, iz, j, m, xi)
		#pragma loop name initialize#1#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			eta=(((double)j)*dnym1);
			//#pragma cetus private(Peta, Pxi, Pzeta, i, ix, iy, iz, m, xi)
			#pragma loop name initialize#1#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				xi=(((double)i)*dnxm1);
				//#pragma cetus private(ix)
				#pragma loop name initialize#1#0#0#0
				for (ix=0; ix<2; ix ++ )
				{
					exact_solution((double)ix, eta, zeta,  & Pface[ix][0][0]);
				}
				//#pragma cetus private(iy)
				#pragma loop name initialize#1#0#0#1
				for (iy=0; iy<2; iy ++ )
				{
					exact_solution(xi, (double)iy, zeta,  & Pface[iy][1][0]);
				}
				//#pragma cetus private(iz)
				#pragma loop name initialize#1#0#0#2
				for (iz=0; iz<2; iz ++ )
				{
					exact_solution(xi, eta, (double)iz,  & Pface[iz][2][0]);
				}
				//#pragma cetus private(Peta, Pxi, Pzeta, m)
				#pragma loop name initialize#1#0#0#3
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(Peta, Pxi, Pzeta, m)
				*/
				for (m=0; m<5; m ++ )
				{
					Pxi=((xi*Pface[1][0][m])+((1.0-xi)*Pface[0][0][m]));
					Peta=((eta*Pface[1][1][m])+((1.0-eta)*Pface[0][1][m]));
					Pzeta=((zeta*Pface[1][2][m])+((1.0-zeta)*Pface[0][2][m]));
					u[k][j][i][m]=((((((Pxi+Peta)+Pzeta)-(Pxi*Peta))-(Pxi*Pzeta))-(Peta*Pzeta))+((Pxi*Peta)*Pzeta));
				}
			}
		}
	}
	i=0;
	xi=0.0;
	//#pragma cetus private(eta, j, k, m, zeta)
	#pragma loop name initialize#2
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(eta, j, m)
		#pragma loop name initialize#2#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			eta=(((double)j)*dnym1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#2#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}
	i=(grid_points[0]-1);
	xi=1.0;
	//#pragma cetus private(eta, j, k, m, zeta)
	#pragma loop name initialize#3
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(eta, j, m)
		#pragma loop name initialize#3#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			eta=(((double)j)*dnym1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#3#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}
	j=0;
	eta=0.0;
	//#pragma cetus private(i, k, m, xi, zeta)
	#pragma loop name initialize#4
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(i, m, xi)
		#pragma loop name initialize#4#0
		for (i=0; i<=(grid_points[0]-1); i ++ )
		{
			xi=(((double)i)*dnxm1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#4#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}
	j=(grid_points[1]-1);
	eta=1.0;
	//#pragma cetus private(i, k, m, xi, zeta)
	#pragma loop name initialize#5
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(i, m, xi)
		#pragma loop name initialize#5#0
		for (i=0; i<=(grid_points[0]-1); i ++ )
		{
			xi=(((double)i)*dnxm1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#5#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}
	k=0;
	zeta=0.0;
	//#pragma cetus private(eta, i, j, m, xi)
	#pragma loop name initialize#6
	for (j=0; j<=(grid_points[1]-1); j ++ )
	{
		eta=(((double)j)*dnym1);
		//#pragma cetus private(i, m, xi)
		#pragma loop name initialize#6#0
		for (i=0; i<=(grid_points[0]-1); i ++ )
		{
			xi=(((double)i)*dnxm1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#6#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}
	k=(grid_points[2]-1);
	zeta=1.0;
	//#pragma cetus private(eta, i, j, m, xi)
	#pragma loop name initialize#7
	for (j=0; j<=(grid_points[1]-1); j ++ )
	{
		eta=(((double)j)*dnym1);
		//#pragma cetus private(i, m, xi)
		#pragma loop name initialize#7#0
		for (i=0; i<=(grid_points[0]-1); i ++ )
		{
			xi=(((double)i)*dnxm1);
			exact_solution(xi, eta, zeta, temp);
			//#pragma cetus private(m)
			#pragma loop name initialize#7#0#0
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(m)
			*/
			for (m=0; m<5; m ++ )
			{
				u[k][j][i][m]=temp[m];
			}
		}
	}

	return ;
}

void lhsinit(double lhs[][3][5][5], int size)
{
	int i, m, n;
	i=size;
	//#pragma cetus private(m, n)
	#pragma loop name lhsinit#0
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m, n)
	*/
	for (n=0; n<5; n ++ )
	{
		//#pragma cetus private(m)
		#pragma loop name lhsinit#0#0
		for (m=0; m<5; m ++ )
		{
			lhs[0][0][n][m]=0.0;
			lhs[0][1][n][m]=0.0;
			lhs[0][2][n][m]=0.0;
			lhs[i][0][n][m]=0.0;
			lhs[i][1][n][m]=0.0;
			lhs[i][2][n][m]=0.0;
		}
	}
	//#pragma cetus private(m)
	#pragma loop name lhsinit#1
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		lhs[0][1][m][m]=1.0;
		lhs[i][1][m][m]=1.0;
	}
	return ;
}

void exact_solution(double xi, double eta, double zeta, double dtemp[5])
{
	int m;
	//#pragma cetus private(m)
	#pragma loop name exact_solution#0
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		dtemp[m]=(((ce[m][0]+(xi*(ce[m][1]+(xi*(ce[m][4]+(xi*(ce[m][7]+(xi*ce[m][10]))))))))+(eta*(ce[m][2]+(eta*(ce[m][5]+(eta*(ce[m][8]+(eta*ce[m][11]))))))))+(zeta*(ce[m][3]+(zeta*(ce[m][6]+(zeta*(ce[m][9]+(zeta*ce[m][12]))))))));
	}
	return ;
}

void exact_rhs()
{
	double dtemp[5], xi, eta, zeta, dtpp;
	int m, i, j, k, ip1, im1, jp1, jm1, km1, kp1;
	//#pragma cetus private(i, j, k, m)
	#pragma loop name exact_rhs#0
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name exact_rhs#0#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name exact_rhs#0#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#0#0#0#0
				for (m=0; m<5; m ++ )
				{
					forcing[k][j][i][m]=0.0;
				}
			}
		}
	}
	//#pragma cetus private(dtpp, eta, i, im1, ip1, j, k, m, xi, zeta)
	#pragma loop name exact_rhs#1
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(dtpp, eta, i, im1, ip1, j, m, xi)
		#pragma loop name exact_rhs#1#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			eta=(((double)j)*dnym1);
			//#pragma cetus private(dtpp, i, m, xi)
			#pragma loop name exact_rhs#1#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				xi=(((double)i)*dnxm1);
				exact_solution(xi, eta, zeta, dtemp);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#1#0#0#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=0; m<5; m ++ )
				{
					ue[i][m]=dtemp[m];
				}
				dtpp=(1.0/dtemp[0]);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#1#0#0#1
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=1; m<5; m ++ )
				{
					buf[i][m]=(dtpp*dtemp[m]);
				}
				cuf[i]=(buf[i][1]*buf[i][1]);
				buf[i][0]=((cuf[i]+(buf[i][2]*buf[i][2]))+(buf[i][3]*buf[i][3]));
				q[i]=(0.5*(((buf[i][1]*ue[i][1])+(buf[i][2]*ue[i][2]))+(buf[i][3]*ue[i][3])));
			}
			//#pragma cetus private(i, im1, ip1)
			#pragma loop name exact_rhs#1#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(i, im1, ip1)
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				im1=(i-1);
				ip1=(i+1);
				forcing[k][j][i][0]=((forcing[k][j][i][0]-(tx2*(ue[ip1][1]-ue[im1][1])))+(dx1tx1*((ue[ip1][0]-(2.0*ue[i][0]))+ue[im1][0])));
				forcing[k][j][i][1]=(((forcing[k][j][i][1]-(tx2*(((ue[ip1][1]*buf[ip1][1])+(c2*(ue[ip1][4]-q[ip1])))-((ue[im1][1]*buf[im1][1])+(c2*(ue[im1][4]-q[im1]))))))+(xxcon1*((buf[ip1][1]-(2.0*buf[i][1]))+buf[im1][1])))+(dx2tx1*((ue[ip1][1]-(2.0*ue[i][1]))+ue[im1][1])));
				forcing[k][j][i][2]=(((forcing[k][j][i][2]-(tx2*((ue[ip1][2]*buf[ip1][1])-(ue[im1][2]*buf[im1][1]))))+(xxcon2*((buf[ip1][2]-(2.0*buf[i][2]))+buf[im1][2])))+(dx3tx1*((ue[ip1][2]-(2.0*ue[i][2]))+ue[im1][2])));
				forcing[k][j][i][3]=(((forcing[k][j][i][3]-(tx2*((ue[ip1][3]*buf[ip1][1])-(ue[im1][3]*buf[im1][1]))))+(xxcon2*((buf[ip1][3]-(2.0*buf[i][3]))+buf[im1][3])))+(dx4tx1*((ue[ip1][3]-(2.0*ue[i][3]))+ue[im1][3])));
				forcing[k][j][i][4]=(((((forcing[k][j][i][4]-(tx2*((buf[ip1][1]*((c1*ue[ip1][4])-(c2*q[ip1])))-(buf[im1][1]*((c1*ue[im1][4])-(c2*q[im1]))))))+((0.5*xxcon3)*((buf[ip1][0]-(2.0*buf[i][0]))+buf[im1][0])))+(xxcon4*((cuf[ip1]-(2.0*cuf[i]))+cuf[im1])))+(xxcon5*((buf[ip1][4]-(2.0*buf[i][4]))+buf[im1][4])))+(dx5tx1*((ue[ip1][4]-(2.0*ue[i][4]))+ue[im1][4])));
			}
			//#pragma cetus private(i, m)
			#pragma loop name exact_rhs#1#0#2
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(i, m)
			*/
			for (m=0; m<5; m ++ )
			{
				i=1;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((5.0*ue[i][m])-(4.0*ue[i+1][m]))+ue[i+2][m])));
				i=2;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((( - 4.0)*ue[i-1][m])+(6.0*ue[i][m]))-(4.0*ue[i+1][m]))+ue[i+2][m])));
			}
			//#pragma cetus private(i, m)
			#pragma loop name exact_rhs#1#0#3
			//#pragma cetus parallel
			#pragma omp parallel for private(i, m)
			for (i=3; i<=(grid_points[0]-4); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#1#0#3#0
				for (m=0; m<5; m ++ )
				{
					forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((ue[i-2][m]-(4.0*ue[i-1][m]))+(6.0*ue[i][m]))-(4.0*ue[i+1][m]))+ue[i+2][m])));
				}
			}
			//#pragma cetus private(i, m)
			#pragma loop name exact_rhs#1#0#4
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(i, m)
			*/
			for (m=0; m<5; m ++ )
			{
				i=(grid_points[0]-3);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((ue[i-2][m]-(4.0*ue[i-1][m]))+(6.0*ue[i][m]))-(4.0*ue[i+1][m]))));
				i=(grid_points[0]-2);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((ue[i-2][m]-(4.0*ue[i-1][m]))+(5.0*ue[i][m]))));
			}
		}
	}
	//#pragma cetus private(dtpp, eta, i, j, jm1, jp1, k, m, xi, zeta)
	#pragma loop name exact_rhs#2
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(dtpp, eta, i, j, jm1, jp1, m, xi)
		#pragma loop name exact_rhs#2#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			xi=(((double)i)*dnxm1);
			//#pragma cetus private(dtpp, eta, j, m)
			#pragma loop name exact_rhs#2#0#0
			for (j=0; j<=(grid_points[1]-1); j ++ )
			{
				eta=(((double)j)*dnym1);
				exact_solution(xi, eta, zeta, dtemp);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#2#0#0#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=0; m<5; m ++ )
				{
					ue[j][m]=dtemp[m];
				}
				dtpp=(1.0/dtemp[0]);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#2#0#0#1
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=1; m<5; m ++ )
				{
					buf[j][m]=(dtpp*dtemp[m]);
				}
				cuf[j]=(buf[j][2]*buf[j][2]);
				buf[j][0]=((cuf[j]+(buf[j][1]*buf[j][1]))+(buf[j][3]*buf[j][3]));
				q[j]=(0.5*(((buf[j][1]*ue[j][1])+(buf[j][2]*ue[j][2]))+(buf[j][3]*ue[j][3])));
			}
			//#pragma cetus private(j, jm1, jp1)
			#pragma loop name exact_rhs#2#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(j, jm1, jp1)
			for (j=1; j<=(grid_points[1]-2); j ++ )
			{
				jm1=(j-1);
				jp1=(j+1);
				forcing[k][j][i][0]=((forcing[k][j][i][0]-(ty2*(ue[jp1][2]-ue[jm1][2])))+(dy1ty1*((ue[jp1][0]-(2.0*ue[j][0]))+ue[jm1][0])));
				forcing[k][j][i][1]=(((forcing[k][j][i][1]-(ty2*((ue[jp1][1]*buf[jp1][2])-(ue[jm1][1]*buf[jm1][2]))))+(yycon2*((buf[jp1][1]-(2.0*buf[j][1]))+buf[jm1][1])))+(dy2ty1*((ue[jp1][1]-(2.0*ue[j][1]))+ue[jm1][1])));
				forcing[k][j][i][2]=(((forcing[k][j][i][2]-(ty2*(((ue[jp1][2]*buf[jp1][2])+(c2*(ue[jp1][4]-q[jp1])))-((ue[jm1][2]*buf[jm1][2])+(c2*(ue[jm1][4]-q[jm1]))))))+(yycon1*((buf[jp1][2]-(2.0*buf[j][2]))+buf[jm1][2])))+(dy3ty1*((ue[jp1][2]-(2.0*ue[j][2]))+ue[jm1][2])));
				forcing[k][j][i][3]=(((forcing[k][j][i][3]-(ty2*((ue[jp1][3]*buf[jp1][2])-(ue[jm1][3]*buf[jm1][2]))))+(yycon2*((buf[jp1][3]-(2.0*buf[j][3]))+buf[jm1][3])))+(dy4ty1*((ue[jp1][3]-(2.0*ue[j][3]))+ue[jm1][3])));
				forcing[k][j][i][4]=(((((forcing[k][j][i][4]-(ty2*((buf[jp1][2]*((c1*ue[jp1][4])-(c2*q[jp1])))-(buf[jm1][2]*((c1*ue[jm1][4])-(c2*q[jm1]))))))+((0.5*yycon3)*((buf[jp1][0]-(2.0*buf[j][0]))+buf[jm1][0])))+(yycon4*((cuf[jp1]-(2.0*cuf[j]))+cuf[jm1])))+(yycon5*((buf[jp1][4]-(2.0*buf[j][4]))+buf[jm1][4])))+(dy5ty1*((ue[jp1][4]-(2.0*ue[j][4]))+ue[jm1][4])));
			}
			//#pragma cetus private(j, m)
			#pragma loop name exact_rhs#2#0#2
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(j, m)
			*/
			for (m=0; m<5; m ++ )
			{
				j=1;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((5.0*ue[j][m])-(4.0*ue[j+1][m]))+ue[j+2][m])));
				j=2;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((( - 4.0)*ue[j-1][m])+(6.0*ue[j][m]))-(4.0*ue[j+1][m]))+ue[j+2][m])));
			}
			//#pragma cetus private(j, m)
			#pragma loop name exact_rhs#2#0#3
			//#pragma cetus parallel
			#pragma omp parallel for private(j, m)
			for (j=3; j<=(grid_points[1]-4); j ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#2#0#3#0
				for (m=0; m<5; m ++ )
				{
					forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((ue[j-2][m]-(4.0*ue[j-1][m]))+(6.0*ue[j][m]))-(4.0*ue[j+1][m]))+ue[j+2][m])));
				}
			}
			//#pragma cetus private(j, m)
			#pragma loop name exact_rhs#2#0#4
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(j, m)
			*/
			for (m=0; m<5; m ++ )
			{
				j=(grid_points[1]-3);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((ue[j-2][m]-(4.0*ue[j-1][m]))+(6.0*ue[j][m]))-(4.0*ue[j+1][m]))));
				j=(grid_points[1]-2);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((ue[j-2][m]-(4.0*ue[j-1][m]))+(5.0*ue[j][m]))));
			}
		}
	}
	//#pragma cetus private(dtpp, eta, i, j, k, km1, kp1, m, xi, zeta)
	#pragma loop name exact_rhs#3
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		eta=(((double)j)*dnym1);
		//#pragma cetus private(dtpp, i, k, km1, kp1, m, xi, zeta)
		#pragma loop name exact_rhs#3#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			xi=(((double)i)*dnxm1);
			//#pragma cetus private(dtpp, k, m, zeta)
			#pragma loop name exact_rhs#3#0#0
			for (k=0; k<=(grid_points[2]-1); k ++ )
			{
				zeta=(((double)k)*dnzm1);
				exact_solution(xi, eta, zeta, dtemp);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#3#0#0#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=0; m<5; m ++ )
				{
					ue[k][m]=dtemp[m];
				}
				dtpp=(1.0/dtemp[0]);
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#3#0#0#1
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m)
				*/
				for (m=1; m<5; m ++ )
				{
					buf[k][m]=(dtpp*dtemp[m]);
				}
				cuf[k]=(buf[k][3]*buf[k][3]);
				buf[k][0]=((cuf[k]+(buf[k][1]*buf[k][1]))+(buf[k][2]*buf[k][2]));
				q[k]=(0.5*(((buf[k][1]*ue[k][1])+(buf[k][2]*ue[k][2]))+(buf[k][3]*ue[k][3])));
			}
			//#pragma cetus private(k, km1, kp1)
			#pragma loop name exact_rhs#3#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(k, km1, kp1)
			for (k=1; k<=(grid_points[2]-2); k ++ )
			{
				km1=(k-1);
				kp1=(k+1);
				forcing[k][j][i][0]=((forcing[k][j][i][0]-(tz2*(ue[kp1][3]-ue[km1][3])))+(dz1tz1*((ue[kp1][0]-(2.0*ue[k][0]))+ue[km1][0])));
				forcing[k][j][i][1]=(((forcing[k][j][i][1]-(tz2*((ue[kp1][1]*buf[kp1][3])-(ue[km1][1]*buf[km1][3]))))+(zzcon2*((buf[kp1][1]-(2.0*buf[k][1]))+buf[km1][1])))+(dz2tz1*((ue[kp1][1]-(2.0*ue[k][1]))+ue[km1][1])));
				forcing[k][j][i][2]=(((forcing[k][j][i][2]-(tz2*((ue[kp1][2]*buf[kp1][3])-(ue[km1][2]*buf[km1][3]))))+(zzcon2*((buf[kp1][2]-(2.0*buf[k][2]))+buf[km1][2])))+(dz3tz1*((ue[kp1][2]-(2.0*ue[k][2]))+ue[km1][2])));
				forcing[k][j][i][3]=(((forcing[k][j][i][3]-(tz2*(((ue[kp1][3]*buf[kp1][3])+(c2*(ue[kp1][4]-q[kp1])))-((ue[km1][3]*buf[km1][3])+(c2*(ue[km1][4]-q[km1]))))))+(zzcon1*((buf[kp1][3]-(2.0*buf[k][3]))+buf[km1][3])))+(dz4tz1*((ue[kp1][3]-(2.0*ue[k][3]))+ue[km1][3])));
				forcing[k][j][i][4]=(((((forcing[k][j][i][4]-(tz2*((buf[kp1][3]*((c1*ue[kp1][4])-(c2*q[kp1])))-(buf[km1][3]*((c1*ue[km1][4])-(c2*q[km1]))))))+((0.5*zzcon3)*((buf[kp1][0]-(2.0*buf[k][0]))+buf[km1][0])))+(zzcon4*((cuf[kp1]-(2.0*cuf[k]))+cuf[km1])))+(zzcon5*((buf[kp1][4]-(2.0*buf[k][4]))+buf[km1][4])))+(dz5tz1*((ue[kp1][4]-(2.0*ue[k][4]))+ue[km1][4])));
			}
			//#pragma cetus private(k, m)
			#pragma loop name exact_rhs#3#0#2
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(k, m)
			*/
			for (m=0; m<5; m ++ )
			{
				k=1;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((5.0*ue[k][m])-(4.0*ue[k+1][m]))+ue[k+2][m])));
				k=2;
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((( - 4.0)*ue[k-1][m])+(6.0*ue[k][m]))-(4.0*ue[k+1][m]))+ue[k+2][m])));
			}
			//#pragma cetus private(k, m)
			#pragma loop name exact_rhs#3#0#3
			//#pragma cetus parallel
			#pragma omp parallel for private(k, m)
			for (k=3; k<=(grid_points[2]-4); k ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#3#0#3#0
				for (m=0; m<5; m ++ )
				{
					forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((((ue[k-2][m]-(4.0*ue[k-1][m]))+(6.0*ue[k][m]))-(4.0*ue[k+1][m]))+ue[k+2][m])));
				}
			}
			//#pragma cetus private(k, m)
			#pragma loop name exact_rhs#3#0#4
			//#pragma cetus parallel
			/*
			Disabled due to low profitability: #pragma omp parallel for private(k, m)
			*/
			for (m=0; m<5; m ++ )
			{
				k=(grid_points[2]-3);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*(((ue[k-2][m]-(4.0*ue[k-1][m]))+(6.0*ue[k][m]))-(4.0*ue[k+1][m]))));
				k=(grid_points[2]-2);
				forcing[k][j][i][m]=(forcing[k][j][i][m]-(dssp*((ue[k-2][m]-(4.0*ue[k-1][m]))+(5.0*ue[k][m]))));
			}
		}
	}
	//#pragma cetus private(i, j, k, m)
	#pragma loop name exact_rhs#4
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name exact_rhs#4#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name exact_rhs#4#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name exact_rhs#4#0#0#0
				for (m=0; m<5; m ++ )
				{
					forcing[k][j][i][m]=(( - 1.0)*forcing[k][j][i][m]);
				}
			}
		}
	}
	return ;
}

void set_constants()
{
	ce[0][0]=2.0;
	ce[0][1]=0.0;
	ce[0][2]=0.0;
	ce[0][3]=4.0;
	ce[0][4]=5.0;
	ce[0][5]=3.0;
	ce[0][6]=0.5;
	ce[0][7]=0.02;
	ce[0][8]=0.01;
	ce[0][9]=0.03;
	ce[0][10]=0.5;
	ce[0][11]=0.4;
	ce[0][12]=0.3;
	ce[1][0]=1.0;
	ce[1][1]=0.0;
	ce[1][2]=0.0;
	ce[1][3]=0.0;
	ce[1][4]=1.0;
	ce[1][5]=2.0;
	ce[1][6]=3.0;
	ce[1][7]=0.01;
	ce[1][8]=0.03;
	ce[1][9]=0.02;
	ce[1][10]=0.4;
	ce[1][11]=0.3;
	ce[1][12]=0.5;
	ce[2][0]=2.0;
	ce[2][1]=2.0;
	ce[2][2]=0.0;
	ce[2][3]=0.0;
	ce[2][4]=0.0;
	ce[2][5]=2.0;
	ce[2][6]=3.0;
	ce[2][7]=0.04;
	ce[2][8]=0.03;
	ce[2][9]=0.05;
	ce[2][10]=0.3;
	ce[2][11]=0.5;
	ce[2][12]=0.4;
	ce[3][0]=2.0;
	ce[3][1]=2.0;
	ce[3][2]=0.0;
	ce[3][3]=0.0;
	ce[3][4]=0.0;
	ce[3][5]=2.0;
	ce[3][6]=3.0;
	ce[3][7]=0.03;
	ce[3][8]=0.05;
	ce[3][9]=0.04;
	ce[3][10]=0.2;
	ce[3][11]=0.1;
	ce[3][12]=0.3;
	ce[4][0]=5.0;
	ce[4][1]=4.0;
	ce[4][2]=3.0;
	ce[4][3]=2.0;
	ce[4][4]=0.1;
	ce[4][5]=0.4;
	ce[4][6]=0.3;
	ce[4][7]=0.05;
	ce[4][8]=0.04;
	ce[4][9]=0.03;
	ce[4][10]=0.1;
	ce[4][11]=0.3;
	ce[4][12]=0.2;
	c1=1.4;
	c2=0.4;
	c3=0.1;
	c4=1.0;
	c5=1.4;
	dnxm1=(1.0/((double)(grid_points[0]-1)));
	dnym1=(1.0/((double)(grid_points[1]-1)));
	dnzm1=(1.0/((double)(grid_points[2]-1)));
	c1c2=(c1*c2);
	c1c5=(c1*c5);
	c3c4=(c3*c4);
	c1345=(c1c5*c3c4);
	conz1=(1.0-c1c5);
	tx1=(1.0/(dnxm1*dnxm1));
	tx2=(1.0/(2.0*dnxm1));
	tx3=(1.0/dnxm1);
	ty1=(1.0/(dnym1*dnym1));
	ty2=(1.0/(2.0*dnym1));
	ty3=(1.0/dnym1);
	tz1=(1.0/(dnzm1*dnzm1));
	tz2=(1.0/(2.0*dnzm1));
	tz3=(1.0/dnzm1);
	dx1=0.75;
	dx2=0.75;
	dx3=0.75;
	dx4=0.75;
	dx5=0.75;
	dy1=0.75;
	dy2=0.75;
	dy3=0.75;
	dy4=0.75;
	dy5=0.75;
	dz1=1.0;
	dz2=1.0;
	dz3=1.0;
	dz4=1.0;
	dz5=1.0;
	dxmax=((dx3>dx4) ? dx3 : dx4);
	dymax=((dy2>dy4) ? dy2 : dy4);
	dzmax=((dz2>dz3) ? dz2 : dz3);
	dssp=(0.25*((dx1>((dy1>dz1) ? dy1 : dz1)) ? dx1 : ((dy1>dz1) ? dy1 : dz1)));
	c4dssp=(4.0*dssp);
	c5dssp=(5.0*dssp);
	dttx1=(dt*tx1);
	dttx2=(dt*tx2);
	dtty1=(dt*ty1);
	dtty2=(dt*ty2);
	dttz1=(dt*tz1);
	dttz2=(dt*tz2);
	c2dttx1=(2.0*dttx1);
	c2dtty1=(2.0*dtty1);
	c2dttz1=(2.0*dttz1);
	dtdssp=(dt*dssp);
	comz1=dtdssp;
	comz4=(4.0*dtdssp);
	comz5=(5.0*dtdssp);
	comz6=(6.0*dtdssp);
	c3c4tx3=(c3c4*tx3);
	c3c4ty3=(c3c4*ty3);
	c3c4tz3=(c3c4*tz3);
	dx1tx1=(dx1*tx1);
	dx2tx1=(dx2*tx1);
	dx3tx1=(dx3*tx1);
	dx4tx1=(dx4*tx1);
	dx5tx1=(dx5*tx1);
	dy1ty1=(dy1*ty1);
	dy2ty1=(dy2*ty1);
	dy3ty1=(dy3*ty1);
	dy4ty1=(dy4*ty1);
	dy5ty1=(dy5*ty1);
	dz1tz1=(dz1*tz1);
	dz2tz1=(dz2*tz1);
	dz3tz1=(dz3*tz1);
	dz4tz1=(dz4*tz1);
	dz5tz1=(dz5*tz1);
	c2iv=2.5;
	con43=(4.0/3.0);
	con16=(1.0/6.0);
	xxcon1=((c3c4tx3*con43)*tx3);
	xxcon2=(c3c4tx3*tx3);
	xxcon3=((c3c4tx3*conz1)*tx3);
	xxcon4=((c3c4tx3*con16)*tx3);
	xxcon5=((c3c4tx3*c1c5)*tx3);
	yycon1=((c3c4ty3*con43)*ty3);
	yycon2=(c3c4ty3*ty3);
	yycon3=((c3c4ty3*conz1)*ty3);
	yycon4=((c3c4ty3*con16)*ty3);
	yycon5=((c3c4ty3*c1c5)*ty3);
	zzcon1=((c3c4tz3*con43)*tz3);
	zzcon2=(c3c4tz3*tz3);
	zzcon3=((c3c4tz3*conz1)*tz3);
	zzcon4=((c3c4tz3*con16)*tz3);
	zzcon5=((c3c4tz3*c1c5)*tz3);
	return ;
}

void adi()
{
	compute_rhs();
	x_solve();
	y_solve();
	z_solve();
	add();
	return ;
}

void compute_rhs()
{
	int i, j, k, m;
	double rho_inv, uijk, up1, um1, vijk, vp1, vm1, wijk, wp1, wm1;
	if (timeron)
	{
		timer_start(5);
	}
	//#pragma cetus private(i, j, k, rho_inv)
	#pragma loop name compute_rhs#0
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, rho_inv)
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		//#pragma cetus private(i, j, rho_inv)
		#pragma loop name compute_rhs#0#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			//#pragma cetus private(i, rho_inv)
			#pragma loop name compute_rhs#0#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				rho_inv=(1.0/u[k][j][i][0]);
				rho_i[k][j][i]=rho_inv;
				us[k][j][i]=(u[k][j][i][1]*rho_inv);
				vs[k][j][i]=(u[k][j][i][2]*rho_inv);
				ws[k][j][i]=(u[k][j][i][3]*rho_inv);
				square[k][j][i]=((0.5*(((u[k][j][i][1]*u[k][j][i][1])+(u[k][j][i][2]*u[k][j][i][2]))+(u[k][j][i][3]*u[k][j][i][3])))*rho_inv);
				qs[k][j][i]=(square[k][j][i]*rho_inv);
			}
		}
	}
	//#pragma cetus private(i, j, k, m)
	#pragma loop name compute_rhs#1
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#1#0
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name compute_rhs#1#0#0
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name compute_rhs#1#0#0#0
				for (m=0; m<5; m ++ )
				{
					rhs[k][j][i][m]=forcing[k][j][i][m];
				}
			}
		}
	}
	if (timeron)
	{
		timer_start(2);
	}
	//#pragma cetus private(i, j, k, m, uijk, um1, up1)
	#pragma loop name compute_rhs#2
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m, uijk, um1, up1)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, uijk, um1, up1)
		#pragma loop name compute_rhs#2#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, uijk, um1, up1)
			#pragma loop name compute_rhs#2#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				uijk=us[k][j][i];
				up1=us[k][j][i+1];
				um1=us[k][j][i-1];
				rhs[k][j][i][0]=((rhs[k][j][i][0]+(dx1tx1*((u[k][j][i+1][0]-(2.0*u[k][j][i][0]))+u[k][j][i-1][0])))-(tx2*(u[k][j][i+1][1]-u[k][j][i-1][1])));
				rhs[k][j][i][1]=(((rhs[k][j][i][1]+(dx2tx1*((u[k][j][i+1][1]-(2.0*u[k][j][i][1]))+u[k][j][i-1][1])))+((xxcon2*con43)*((up1-(2.0*uijk))+um1)))-(tx2*(((u[k][j][i+1][1]*up1)-(u[k][j][i-1][1]*um1))+((((u[k][j][i+1][4]-square[k][j][i+1])-u[k][j][i-1][4])+square[k][j][i-1])*c2))));
				rhs[k][j][i][2]=(((rhs[k][j][i][2]+(dx3tx1*((u[k][j][i+1][2]-(2.0*u[k][j][i][2]))+u[k][j][i-1][2])))+(xxcon2*((vs[k][j][i+1]-(2.0*vs[k][j][i]))+vs[k][j][i-1])))-(tx2*((u[k][j][i+1][2]*up1)-(u[k][j][i-1][2]*um1))));
				rhs[k][j][i][3]=(((rhs[k][j][i][3]+(dx4tx1*((u[k][j][i+1][3]-(2.0*u[k][j][i][3]))+u[k][j][i-1][3])))+(xxcon2*((ws[k][j][i+1]-(2.0*ws[k][j][i]))+ws[k][j][i-1])))-(tx2*((u[k][j][i+1][3]*up1)-(u[k][j][i-1][3]*um1))));
				rhs[k][j][i][4]=(((((rhs[k][j][i][4]+(dx5tx1*((u[k][j][i+1][4]-(2.0*u[k][j][i][4]))+u[k][j][i-1][4])))+(xxcon3*((qs[k][j][i+1]-(2.0*qs[k][j][i]))+qs[k][j][i-1])))+(xxcon4*(((up1*up1)-((2.0*uijk)*uijk))+(um1*um1))))+(xxcon5*(((u[k][j][i+1][4]*rho_i[k][j][i+1])-((2.0*u[k][j][i][4])*rho_i[k][j][i]))+(u[k][j][i-1][4]*rho_i[k][j][i-1]))))-(tx2*((((c1*u[k][j][i+1][4])-(c2*square[k][j][i+1]))*up1)-(((c1*u[k][j][i-1][4])-(c2*square[k][j][i-1]))*um1))));
			}
		}
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#2#1
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			i=1;
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#2#1#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((5.0*u[k][j][i][m])-(4.0*u[k][j][i+1][m]))+u[k][j][i+2][m])));
			}
			i=2;
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#2#1#1
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((( - 4.0)*u[k][j][i-1][m])+(6.0*u[k][j][i][m]))-(4.0*u[k][j][i+1][m]))+u[k][j][i+2][m])));
			}
		}
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#2#2
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name compute_rhs#2#2#0
			for (i=3; i<=(grid_points[0]-4); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name compute_rhs#2#2#0#0
				for (m=0; m<5; m ++ )
				{
					rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((u[k][j][i-2][m]-(4.0*u[k][j][i-1][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k][j][i+1][m]))+u[k][j][i+2][m])));
				}
			}
		}
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#2#3
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			i=(grid_points[0]-3);
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#2#3#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((u[k][j][i-2][m]-(4.0*u[k][j][i-1][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k][j][i+1][m]))));
			}
			i=(grid_points[0]-2);
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#2#3#1
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((u[k][j][i-2][m]-(4.0*u[k][j][i-1][m]))+(5.0*u[k][j][i][m]))));
			}
		}
	}
	if (timeron)
	{
		timer_stop(2);
	}
	if (timeron)
	{
		timer_start(3);
	}
	//#pragma cetus private(i, j, k, m, vijk, vm1, vp1)
	#pragma loop name compute_rhs#3
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m, vijk, vm1, vp1)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, vijk, vm1, vp1)
		#pragma loop name compute_rhs#3#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, vijk, vm1, vp1)
			#pragma loop name compute_rhs#3#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				vijk=vs[k][j][i];
				vp1=vs[k][j+1][i];
				vm1=vs[k][j-1][i];
				rhs[k][j][i][0]=((rhs[k][j][i][0]+(dy1ty1*((u[k][j+1][i][0]-(2.0*u[k][j][i][0]))+u[k][j-1][i][0])))-(ty2*(u[k][j+1][i][2]-u[k][j-1][i][2])));
				rhs[k][j][i][1]=(((rhs[k][j][i][1]+(dy2ty1*((u[k][j+1][i][1]-(2.0*u[k][j][i][1]))+u[k][j-1][i][1])))+(yycon2*((us[k][j+1][i]-(2.0*us[k][j][i]))+us[k][j-1][i])))-(ty2*((u[k][j+1][i][1]*vp1)-(u[k][j-1][i][1]*vm1))));
				rhs[k][j][i][2]=(((rhs[k][j][i][2]+(dy3ty1*((u[k][j+1][i][2]-(2.0*u[k][j][i][2]))+u[k][j-1][i][2])))+((yycon2*con43)*((vp1-(2.0*vijk))+vm1)))-(ty2*(((u[k][j+1][i][2]*vp1)-(u[k][j-1][i][2]*vm1))+((((u[k][j+1][i][4]-square[k][j+1][i])-u[k][j-1][i][4])+square[k][j-1][i])*c2))));
				rhs[k][j][i][3]=(((rhs[k][j][i][3]+(dy4ty1*((u[k][j+1][i][3]-(2.0*u[k][j][i][3]))+u[k][j-1][i][3])))+(yycon2*((ws[k][j+1][i]-(2.0*ws[k][j][i]))+ws[k][j-1][i])))-(ty2*((u[k][j+1][i][3]*vp1)-(u[k][j-1][i][3]*vm1))));
				rhs[k][j][i][4]=(((((rhs[k][j][i][4]+(dy5ty1*((u[k][j+1][i][4]-(2.0*u[k][j][i][4]))+u[k][j-1][i][4])))+(yycon3*((qs[k][j+1][i]-(2.0*qs[k][j][i]))+qs[k][j-1][i])))+(yycon4*(((vp1*vp1)-((2.0*vijk)*vijk))+(vm1*vm1))))+(yycon5*(((u[k][j+1][i][4]*rho_i[k][j+1][i])-((2.0*u[k][j][i][4])*rho_i[k][j][i]))+(u[k][j-1][i][4]*rho_i[k][j-1][i]))))-(ty2*((((c1*u[k][j+1][i][4])-(c2*square[k][j+1][i]))*vp1)-(((c1*u[k][j-1][i][4])-(c2*square[k][j-1][i]))*vm1))));
			}
		}
		j=1;
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#3#1
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#3#1#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((5.0*u[k][j][i][m])-(4.0*u[k][j+1][i][m]))+u[k][j+2][i][m])));
			}
		}
		j=2;
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#3#2
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#3#2#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((( - 4.0)*u[k][j-1][i][m])+(6.0*u[k][j][i][m]))-(4.0*u[k][j+1][i][m]))+u[k][j+2][i][m])));
			}
		}
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#3#3
		for (j=3; j<=(grid_points[1]-4); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name compute_rhs#3#3#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name compute_rhs#3#3#0#0
				for (m=0; m<5; m ++ )
				{
					rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((u[k][j-2][i][m]-(4.0*u[k][j-1][i][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k][j+1][i][m]))+u[k][j+2][i][m])));
				}
			}
		}
		j=(grid_points[1]-3);
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#3#4
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#3#4#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((u[k][j-2][i][m]-(4.0*u[k][j-1][i][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k][j+1][i][m]))));
			}
		}
		j=(grid_points[1]-2);
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#3#5
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#3#5#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((u[k][j-2][i][m]-(4.0*u[k][j-1][i][m]))+(5.0*u[k][j][i][m]))));
			}
		}
	}
	if (timeron)
	{
		timer_stop(3);
	}
	if (timeron)
	{
		timer_start(4);
	}
	//#pragma cetus private(i, j, k, wijk, wm1, wp1)
	#pragma loop name compute_rhs#4
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, wijk, wm1, wp1)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, wijk, wm1, wp1)
		#pragma loop name compute_rhs#4#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, wijk, wm1, wp1)
			#pragma loop name compute_rhs#4#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				wijk=ws[k][j][i];
				wp1=ws[k+1][j][i];
				wm1=ws[k-1][j][i];
				rhs[k][j][i][0]=((rhs[k][j][i][0]+(dz1tz1*((u[k+1][j][i][0]-(2.0*u[k][j][i][0]))+u[k-1][j][i][0])))-(tz2*(u[k+1][j][i][3]-u[k-1][j][i][3])));
				rhs[k][j][i][1]=(((rhs[k][j][i][1]+(dz2tz1*((u[k+1][j][i][1]-(2.0*u[k][j][i][1]))+u[k-1][j][i][1])))+(zzcon2*((us[k+1][j][i]-(2.0*us[k][j][i]))+us[k-1][j][i])))-(tz2*((u[k+1][j][i][1]*wp1)-(u[k-1][j][i][1]*wm1))));
				rhs[k][j][i][2]=(((rhs[k][j][i][2]+(dz3tz1*((u[k+1][j][i][2]-(2.0*u[k][j][i][2]))+u[k-1][j][i][2])))+(zzcon2*((vs[k+1][j][i]-(2.0*vs[k][j][i]))+vs[k-1][j][i])))-(tz2*((u[k+1][j][i][2]*wp1)-(u[k-1][j][i][2]*wm1))));
				rhs[k][j][i][3]=(((rhs[k][j][i][3]+(dz4tz1*((u[k+1][j][i][3]-(2.0*u[k][j][i][3]))+u[k-1][j][i][3])))+((zzcon2*con43)*((wp1-(2.0*wijk))+wm1)))-(tz2*(((u[k+1][j][i][3]*wp1)-(u[k-1][j][i][3]*wm1))+((((u[k+1][j][i][4]-square[k+1][j][i])-u[k-1][j][i][4])+square[k-1][j][i])*c2))));
				rhs[k][j][i][4]=(((((rhs[k][j][i][4]+(dz5tz1*((u[k+1][j][i][4]-(2.0*u[k][j][i][4]))+u[k-1][j][i][4])))+(zzcon3*((qs[k+1][j][i]-(2.0*qs[k][j][i]))+qs[k-1][j][i])))+(zzcon4*(((wp1*wp1)-((2.0*wijk)*wijk))+(wm1*wm1))))+(zzcon5*(((u[k+1][j][i][4]*rho_i[k+1][j][i])-((2.0*u[k][j][i][4])*rho_i[k][j][i]))+(u[k-1][j][i][4]*rho_i[k-1][j][i]))))-(tz2*((((c1*u[k+1][j][i][4])-(c2*square[k+1][j][i]))*wp1)-(((c1*u[k-1][j][i][4])-(c2*square[k-1][j][i]))*wm1))));
			}
		}
	}
	k=1;
	//#pragma cetus private(i, j, m)
	#pragma loop name compute_rhs#5
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, m)
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#5#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#5#0#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((5.0*u[k][j][i][m])-(4.0*u[k+1][j][i][m]))+u[k+2][j][i][m])));
			}
		}
	}
	k=2;
	//#pragma cetus private(i, j, m)
	#pragma loop name compute_rhs#6
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, m)
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#6#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#6#0#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((( - 4.0)*u[k-1][j][i][m])+(6.0*u[k][j][i][m]))-(4.0*u[k+1][j][i][m]))+u[k+2][j][i][m])));
			}
		}
	}
	//#pragma cetus private(i, j, k, m)
	#pragma loop name compute_rhs#7
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=3; k<=(grid_points[2]-4); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#7#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name compute_rhs#7#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name compute_rhs#7#0#0#0
				for (m=0; m<5; m ++ )
				{
					rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((((u[k-2][j][i][m]-(4.0*u[k-1][j][i][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k+1][j][i][m]))+u[k+2][j][i][m])));
				}
			}
		}
	}
	k=(grid_points[2]-3);
	//#pragma cetus private(i, j, m)
	#pragma loop name compute_rhs#8
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, m)
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#8#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#8#0#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*(((u[k-2][j][i][m]-(4.0*u[k-1][j][i][m]))+(6.0*u[k][j][i][m]))-(4.0*u[k+1][j][i][m]))));
			}
		}
	}
	k=(grid_points[2]-2);
	//#pragma cetus private(i, j, m)
	#pragma loop name compute_rhs#9
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, m)
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		//#pragma cetus private(i, m)
		#pragma loop name compute_rhs#9#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(m)
			#pragma loop name compute_rhs#9#0#0
			for (m=0; m<5; m ++ )
			{
				rhs[k][j][i][m]=(rhs[k][j][i][m]-(dssp*((u[k-2][j][i][m]-(4.0*u[k-1][j][i][m]))+(5.0*u[k][j][i][m]))));
			}
		}
	}
	if (timeron)
	{
		timer_stop(4);
	}
	//#pragma cetus private(i, j, k, m)
	#pragma loop name compute_rhs#10
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name compute_rhs#10#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name compute_rhs#10#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name compute_rhs#10#0#0#0
				for (m=0; m<5; m ++ )
				{
					rhs[k][j][i][m]=(rhs[k][j][i][m]*dt);
				}
			}
		}
	}
	if (timeron)
	{
		timer_stop(5);
	}
	return ;
}

void x_solve()
{
	int i, j, k, m, n, isize;
	if (timeron)
	{
		timer_start(6);
	}
	isize=(grid_points[0]-1);

	//#pragma cetus private(i, j, k, m, n)
	#pragma loop name x_solve#0
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, m, n)
		#pragma loop name x_solve#0#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i)
			//#pragma cetus lastprivate(tmp1, tmp2, tmp3)
			#pragma loop name x_solve#0#0#0
			//#pragma cetus parallel
			#pragma omp parallel for private(i) lastprivate(tmp1, tmp2, tmp3)
			for (i=0; i<=isize; i ++ )
			{
				tmp1=rho_i[k][j][i];
				tmp2=(tmp1*tmp1);
				tmp3=(tmp1*tmp2);
				fjac[i][0][0]=0.0;
				fjac[i][1][0]=1.0;
				fjac[i][2][0]=0.0;
				fjac[i][3][0]=0.0;
				fjac[i][4][0]=0.0;
				fjac[i][0][1]=(( - ((u[k][j][i][1]*tmp2)*u[k][j][i][1]))+(c2*qs[k][j][i]));
				fjac[i][1][1]=((2.0-c2)*(u[k][j][i][1]/u[k][j][i][0]));
				fjac[i][2][1]=(( - c2)*(u[k][j][i][2]*tmp1));
				fjac[i][3][1]=(( - c2)*(u[k][j][i][3]*tmp1));
				fjac[i][4][1]=c2;
				fjac[i][0][2]=(( - (u[k][j][i][1]*u[k][j][i][2]))*tmp2);
				fjac[i][1][2]=(u[k][j][i][2]*tmp1);
				fjac[i][2][2]=(u[k][j][i][1]*tmp1);
				fjac[i][3][2]=0.0;
				fjac[i][4][2]=0.0;
				fjac[i][0][3]=(( - (u[k][j][i][1]*u[k][j][i][3]))*tmp2);
				fjac[i][1][3]=(u[k][j][i][3]*tmp1);
				fjac[i][2][3]=0.0;
				fjac[i][3][3]=(u[k][j][i][1]*tmp1);
				fjac[i][4][3]=0.0;
				fjac[i][0][4]=((((c2*2.0)*square[k][j][i])-(c1*u[k][j][i][4]))*(u[k][j][i][1]*tmp2));
				fjac[i][1][4]=(((c1*u[k][j][i][4])*tmp1)-(c2*(((u[k][j][i][1]*u[k][j][i][1])*tmp2)+qs[k][j][i])));
				fjac[i][2][4]=((( - c2)*(u[k][j][i][2]*u[k][j][i][1]))*tmp2);
				fjac[i][3][4]=((( - c2)*(u[k][j][i][3]*u[k][j][i][1]))*tmp2);
				fjac[i][4][4]=(c1*(u[k][j][i][1]*tmp1));
				njac[i][0][0]=0.0;
				njac[i][1][0]=0.0;
				njac[i][2][0]=0.0;
				njac[i][3][0]=0.0;
				njac[i][4][0]=0.0;
				njac[i][0][1]=(((( - con43)*c3c4)*tmp2)*u[k][j][i][1]);
				njac[i][1][1]=((con43*c3c4)*tmp1);
				njac[i][2][1]=0.0;
				njac[i][3][1]=0.0;
				njac[i][4][1]=0.0;
				njac[i][0][2]=((( - c3c4)*tmp2)*u[k][j][i][2]);
				njac[i][1][2]=0.0;
				njac[i][2][2]=(c3c4*tmp1);
				njac[i][3][2]=0.0;
				njac[i][4][2]=0.0;
				njac[i][0][3]=((( - c3c4)*tmp2)*u[k][j][i][3]);
				njac[i][1][3]=0.0;
				njac[i][2][3]=0.0;
				njac[i][3][3]=(c3c4*tmp1);
				njac[i][4][3]=0.0;
				njac[i][0][4]=(((((( - ((con43*c3c4)-c1345))*tmp3)*(u[k][j][i][1]*u[k][j][i][1]))-(((c3c4-c1345)*tmp3)*(u[k][j][i][2]*u[k][j][i][2])))-(((c3c4-c1345)*tmp3)*(u[k][j][i][3]*u[k][j][i][3])))-((c1345*tmp2)*u[k][j][i][4]));
				njac[i][1][4]=((((con43*c3c4)-c1345)*tmp2)*u[k][j][i][1]);
				njac[i][2][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][2]);
				njac[i][3][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][3]);
				njac[i][4][4]=(c1345*tmp1);
			}
			lhsinit(lhs, isize);
			//#pragma cetus private(i)
			//#pragma cetus lastprivate(tmp1, tmp2)
			#pragma loop name x_solve#0#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(i) lastprivate(tmp1, tmp2)
			for (i=1; i<=(isize-1); i ++ )
			{
				tmp1=(dt*tx1);
				tmp2=(dt*tx2);
				lhs[i][0][0][0]=(((( - tmp2)*fjac[i-1][0][0])-(tmp1*njac[i-1][0][0]))-(tmp1*dx1));
				lhs[i][0][1][0]=((( - tmp2)*fjac[i-1][1][0])-(tmp1*njac[i-1][1][0]));
				lhs[i][0][2][0]=((( - tmp2)*fjac[i-1][2][0])-(tmp1*njac[i-1][2][0]));
				lhs[i][0][3][0]=((( - tmp2)*fjac[i-1][3][0])-(tmp1*njac[i-1][3][0]));
				lhs[i][0][4][0]=((( - tmp2)*fjac[i-1][4][0])-(tmp1*njac[i-1][4][0]));
				lhs[i][0][0][1]=((( - tmp2)*fjac[i-1][0][1])-(tmp1*njac[i-1][0][1]));
				lhs[i][0][1][1]=(((( - tmp2)*fjac[i-1][1][1])-(tmp1*njac[i-1][1][1]))-(tmp1*dx2));
				lhs[i][0][2][1]=((( - tmp2)*fjac[i-1][2][1])-(tmp1*njac[i-1][2][1]));
				lhs[i][0][3][1]=((( - tmp2)*fjac[i-1][3][1])-(tmp1*njac[i-1][3][1]));
				lhs[i][0][4][1]=((( - tmp2)*fjac[i-1][4][1])-(tmp1*njac[i-1][4][1]));
				lhs[i][0][0][2]=((( - tmp2)*fjac[i-1][0][2])-(tmp1*njac[i-1][0][2]));
				lhs[i][0][1][2]=((( - tmp2)*fjac[i-1][1][2])-(tmp1*njac[i-1][1][2]));
				lhs[i][0][2][2]=(((( - tmp2)*fjac[i-1][2][2])-(tmp1*njac[i-1][2][2]))-(tmp1*dx3));
				lhs[i][0][3][2]=((( - tmp2)*fjac[i-1][3][2])-(tmp1*njac[i-1][3][2]));
				lhs[i][0][4][2]=((( - tmp2)*fjac[i-1][4][2])-(tmp1*njac[i-1][4][2]));
				lhs[i][0][0][3]=((( - tmp2)*fjac[i-1][0][3])-(tmp1*njac[i-1][0][3]));
				lhs[i][0][1][3]=((( - tmp2)*fjac[i-1][1][3])-(tmp1*njac[i-1][1][3]));
				lhs[i][0][2][3]=((( - tmp2)*fjac[i-1][2][3])-(tmp1*njac[i-1][2][3]));
				lhs[i][0][3][3]=(((( - tmp2)*fjac[i-1][3][3])-(tmp1*njac[i-1][3][3]))-(tmp1*dx4));
				lhs[i][0][4][3]=((( - tmp2)*fjac[i-1][4][3])-(tmp1*njac[i-1][4][3]));
				lhs[i][0][0][4]=((( - tmp2)*fjac[i-1][0][4])-(tmp1*njac[i-1][0][4]));
				lhs[i][0][1][4]=((( - tmp2)*fjac[i-1][1][4])-(tmp1*njac[i-1][1][4]));
				lhs[i][0][2][4]=((( - tmp2)*fjac[i-1][2][4])-(tmp1*njac[i-1][2][4]));
				lhs[i][0][3][4]=((( - tmp2)*fjac[i-1][3][4])-(tmp1*njac[i-1][3][4]));
				lhs[i][0][4][4]=(((( - tmp2)*fjac[i-1][4][4])-(tmp1*njac[i-1][4][4]))-(tmp1*dx5));
				lhs[i][1][0][0]=((1.0+((tmp1*2.0)*njac[i][0][0]))+((tmp1*2.0)*dx1));
				lhs[i][1][1][0]=((tmp1*2.0)*njac[i][1][0]);
				lhs[i][1][2][0]=((tmp1*2.0)*njac[i][2][0]);
				lhs[i][1][3][0]=((tmp1*2.0)*njac[i][3][0]);
				lhs[i][1][4][0]=((tmp1*2.0)*njac[i][4][0]);
				lhs[i][1][0][1]=((tmp1*2.0)*njac[i][0][1]);
				lhs[i][1][1][1]=((1.0+((tmp1*2.0)*njac[i][1][1]))+((tmp1*2.0)*dx2));
				lhs[i][1][2][1]=((tmp1*2.0)*njac[i][2][1]);
				lhs[i][1][3][1]=((tmp1*2.0)*njac[i][3][1]);
				lhs[i][1][4][1]=((tmp1*2.0)*njac[i][4][1]);
				lhs[i][1][0][2]=((tmp1*2.0)*njac[i][0][2]);
				lhs[i][1][1][2]=((tmp1*2.0)*njac[i][1][2]);
				lhs[i][1][2][2]=((1.0+((tmp1*2.0)*njac[i][2][2]))+((tmp1*2.0)*dx3));
				lhs[i][1][3][2]=((tmp1*2.0)*njac[i][3][2]);
				lhs[i][1][4][2]=((tmp1*2.0)*njac[i][4][2]);
				lhs[i][1][0][3]=((tmp1*2.0)*njac[i][0][3]);
				lhs[i][1][1][3]=((tmp1*2.0)*njac[i][1][3]);
				lhs[i][1][2][3]=((tmp1*2.0)*njac[i][2][3]);
				lhs[i][1][3][3]=((1.0+((tmp1*2.0)*njac[i][3][3]))+((tmp1*2.0)*dx4));
				lhs[i][1][4][3]=((tmp1*2.0)*njac[i][4][3]);
				lhs[i][1][0][4]=((tmp1*2.0)*njac[i][0][4]);
				lhs[i][1][1][4]=((tmp1*2.0)*njac[i][1][4]);
				lhs[i][1][2][4]=((tmp1*2.0)*njac[i][2][4]);
				lhs[i][1][3][4]=((tmp1*2.0)*njac[i][3][4]);
				lhs[i][1][4][4]=((1.0+((tmp1*2.0)*njac[i][4][4]))+((tmp1*2.0)*dx5));
				lhs[i][2][0][0]=(((tmp2*fjac[i+1][0][0])-(tmp1*njac[i+1][0][0]))-(tmp1*dx1));
				lhs[i][2][1][0]=((tmp2*fjac[i+1][1][0])-(tmp1*njac[i+1][1][0]));
				lhs[i][2][2][0]=((tmp2*fjac[i+1][2][0])-(tmp1*njac[i+1][2][0]));
				lhs[i][2][3][0]=((tmp2*fjac[i+1][3][0])-(tmp1*njac[i+1][3][0]));
				lhs[i][2][4][0]=((tmp2*fjac[i+1][4][0])-(tmp1*njac[i+1][4][0]));
				lhs[i][2][0][1]=((tmp2*fjac[i+1][0][1])-(tmp1*njac[i+1][0][1]));
				lhs[i][2][1][1]=(((tmp2*fjac[i+1][1][1])-(tmp1*njac[i+1][1][1]))-(tmp1*dx2));
				lhs[i][2][2][1]=((tmp2*fjac[i+1][2][1])-(tmp1*njac[i+1][2][1]));
				lhs[i][2][3][1]=((tmp2*fjac[i+1][3][1])-(tmp1*njac[i+1][3][1]));
				lhs[i][2][4][1]=((tmp2*fjac[i+1][4][1])-(tmp1*njac[i+1][4][1]));
				lhs[i][2][0][2]=((tmp2*fjac[i+1][0][2])-(tmp1*njac[i+1][0][2]));
				lhs[i][2][1][2]=((tmp2*fjac[i+1][1][2])-(tmp1*njac[i+1][1][2]));
				lhs[i][2][2][2]=(((tmp2*fjac[i+1][2][2])-(tmp1*njac[i+1][2][2]))-(tmp1*dx3));
				lhs[i][2][3][2]=((tmp2*fjac[i+1][3][2])-(tmp1*njac[i+1][3][2]));
				lhs[i][2][4][2]=((tmp2*fjac[i+1][4][2])-(tmp1*njac[i+1][4][2]));
				lhs[i][2][0][3]=((tmp2*fjac[i+1][0][3])-(tmp1*njac[i+1][0][3]));
				lhs[i][2][1][3]=((tmp2*fjac[i+1][1][3])-(tmp1*njac[i+1][1][3]));
				lhs[i][2][2][3]=((tmp2*fjac[i+1][2][3])-(tmp1*njac[i+1][2][3]));
				lhs[i][2][3][3]=(((tmp2*fjac[i+1][3][3])-(tmp1*njac[i+1][3][3]))-(tmp1*dx4));
				lhs[i][2][4][3]=((tmp2*fjac[i+1][4][3])-(tmp1*njac[i+1][4][3]));
				lhs[i][2][0][4]=((tmp2*fjac[i+1][0][4])-(tmp1*njac[i+1][0][4]));
				lhs[i][2][1][4]=((tmp2*fjac[i+1][1][4])-(tmp1*njac[i+1][1][4]));
				lhs[i][2][2][4]=((tmp2*fjac[i+1][2][4])-(tmp1*njac[i+1][2][4]));
				lhs[i][2][3][4]=((tmp2*fjac[i+1][3][4])-(tmp1*njac[i+1][3][4]));
				lhs[i][2][4][4]=(((tmp2*fjac[i+1][4][4])-(tmp1*njac[i+1][4][4]))-(tmp1*dx5));
			}
			binvcrhs(lhs[0][1], lhs[0][2], rhs[k][j][0]);
			//#pragma cetus private(i)
			#pragma loop name x_solve#0#0#2
			for (i=1; i<=(isize-1); i ++ )
			{
				matvec_sub(lhs[i][0], rhs[k][j][i-1], rhs[k][j][i]);
				matmul_sub(lhs[i][0], lhs[i-1][2], lhs[i][1]);
				binvcrhs(lhs[i][1], lhs[i][2], rhs[k][j][i]);
			}
			matvec_sub(lhs[isize][0], rhs[k][j][isize-1], rhs[k][j][isize]);
			matmul_sub(lhs[isize][0], lhs[isize-1][2], lhs[isize][1]);
			binvrhs(lhs[isize][1], rhs[k][j][isize]);
			//#pragma cetus private(i, m, n)
			#pragma loop name x_solve#0#0#3
			for (i=(isize-1); i>=0; i -- )
			{
				//#pragma cetus private(m, n)
				#pragma loop name x_solve#0#0#3#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m, n)
				*/
				for (m=0; m<5; m ++ )
				{
					//#pragma cetus private(n)
					#pragma loop name x_solve#0#0#3#0#0
					for (n=0; n<5; n ++ )
					{
						rhs[k][j][i][m]=(rhs[k][j][i][m]-(lhs[i][2][n][m]*rhs[k][j][i+1][n]));
					}
				}
			}
		}
	}

	if (timeron)
	{
		timer_stop(6);
	}
	return ;
}

void y_solve()
{
	int i, j, k, m, n, jsize;
	if (timeron)
	{
		timer_start(7);
	}
	jsize=(grid_points[1]-1);

	//#pragma cetus private(i, j, k, m, n)
	#pragma loop name y_solve#0
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, m, n)
		#pragma loop name y_solve#0#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(j)
			//#pragma cetus lastprivate(tmp1, tmp2, tmp3)
			#pragma loop name y_solve#0#0#0
			//#pragma cetus parallel
			#pragma omp parallel for private(j) lastprivate(tmp1, tmp2, tmp3)
			for (j=0; j<=jsize; j ++ )
			{
				tmp1=rho_i[k][j][i];
				tmp2=(tmp1*tmp1);
				tmp3=(tmp1*tmp2);
				fjac[j][0][0]=0.0;
				fjac[j][1][0]=0.0;
				fjac[j][2][0]=1.0;
				fjac[j][3][0]=0.0;
				fjac[j][4][0]=0.0;
				fjac[j][0][1]=(( - (u[k][j][i][1]*u[k][j][i][2]))*tmp2);
				fjac[j][1][1]=(u[k][j][i][2]*tmp1);
				fjac[j][2][1]=(u[k][j][i][1]*tmp1);
				fjac[j][3][1]=0.0;
				fjac[j][4][1]=0.0;
				fjac[j][0][2]=(( - ((u[k][j][i][2]*u[k][j][i][2])*tmp2))+(c2*qs[k][j][i]));
				fjac[j][1][2]=((( - c2)*u[k][j][i][1])*tmp1);
				fjac[j][2][2]=(((2.0-c2)*u[k][j][i][2])*tmp1);
				fjac[j][3][2]=((( - c2)*u[k][j][i][3])*tmp1);
				fjac[j][4][2]=c2;
				fjac[j][0][3]=(( - (u[k][j][i][2]*u[k][j][i][3]))*tmp2);
				fjac[j][1][3]=0.0;
				fjac[j][2][3]=(u[k][j][i][3]*tmp1);
				fjac[j][3][3]=(u[k][j][i][2]*tmp1);
				fjac[j][4][3]=0.0;
				fjac[j][0][4]=(((((c2*2.0)*square[k][j][i])-(c1*u[k][j][i][4]))*u[k][j][i][2])*tmp2);
				fjac[j][1][4]=(((( - c2)*u[k][j][i][1])*u[k][j][i][2])*tmp2);
				fjac[j][2][4]=(((c1*u[k][j][i][4])*tmp1)-(c2*(qs[k][j][i]+((u[k][j][i][2]*u[k][j][i][2])*tmp2))));
				fjac[j][3][4]=((( - c2)*(u[k][j][i][2]*u[k][j][i][3]))*tmp2);
				fjac[j][4][4]=((c1*u[k][j][i][2])*tmp1);
				njac[j][0][0]=0.0;
				njac[j][1][0]=0.0;
				njac[j][2][0]=0.0;
				njac[j][3][0]=0.0;
				njac[j][4][0]=0.0;
				njac[j][0][1]=((( - c3c4)*tmp2)*u[k][j][i][1]);
				njac[j][1][1]=(c3c4*tmp1);
				njac[j][2][1]=0.0;
				njac[j][3][1]=0.0;
				njac[j][4][1]=0.0;
				njac[j][0][2]=(((( - con43)*c3c4)*tmp2)*u[k][j][i][2]);
				njac[j][1][2]=0.0;
				njac[j][2][2]=((con43*c3c4)*tmp1);
				njac[j][3][2]=0.0;
				njac[j][4][2]=0.0;
				njac[j][0][3]=((( - c3c4)*tmp2)*u[k][j][i][3]);
				njac[j][1][3]=0.0;
				njac[j][2][3]=0.0;
				njac[j][3][3]=(c3c4*tmp1);
				njac[j][4][3]=0.0;
				njac[j][0][4]=(((((( - (c3c4-c1345))*tmp3)*(u[k][j][i][1]*u[k][j][i][1]))-((((con43*c3c4)-c1345)*tmp3)*(u[k][j][i][2]*u[k][j][i][2])))-(((c3c4-c1345)*tmp3)*(u[k][j][i][3]*u[k][j][i][3])))-((c1345*tmp2)*u[k][j][i][4]));
				njac[j][1][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][1]);
				njac[j][2][4]=((((con43*c3c4)-c1345)*tmp2)*u[k][j][i][2]);
				njac[j][3][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][3]);
				njac[j][4][4]=(c1345*tmp1);
			}
			lhsinit(lhs, jsize);
			//#pragma cetus private(j)
			//#pragma cetus lastprivate(tmp1, tmp2)
			#pragma loop name y_solve#0#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(j) lastprivate(tmp1, tmp2)
			for (j=1; j<=(jsize-1); j ++ )
			{
				tmp1=(dt*ty1);
				tmp2=(dt*ty2);
				lhs[j][0][0][0]=(((( - tmp2)*fjac[j-1][0][0])-(tmp1*njac[j-1][0][0]))-(tmp1*dy1));
				lhs[j][0][1][0]=((( - tmp2)*fjac[j-1][1][0])-(tmp1*njac[j-1][1][0]));
				lhs[j][0][2][0]=((( - tmp2)*fjac[j-1][2][0])-(tmp1*njac[j-1][2][0]));
				lhs[j][0][3][0]=((( - tmp2)*fjac[j-1][3][0])-(tmp1*njac[j-1][3][0]));
				lhs[j][0][4][0]=((( - tmp2)*fjac[j-1][4][0])-(tmp1*njac[j-1][4][0]));
				lhs[j][0][0][1]=((( - tmp2)*fjac[j-1][0][1])-(tmp1*njac[j-1][0][1]));
				lhs[j][0][1][1]=(((( - tmp2)*fjac[j-1][1][1])-(tmp1*njac[j-1][1][1]))-(tmp1*dy2));
				lhs[j][0][2][1]=((( - tmp2)*fjac[j-1][2][1])-(tmp1*njac[j-1][2][1]));
				lhs[j][0][3][1]=((( - tmp2)*fjac[j-1][3][1])-(tmp1*njac[j-1][3][1]));
				lhs[j][0][4][1]=((( - tmp2)*fjac[j-1][4][1])-(tmp1*njac[j-1][4][1]));
				lhs[j][0][0][2]=((( - tmp2)*fjac[j-1][0][2])-(tmp1*njac[j-1][0][2]));
				lhs[j][0][1][2]=((( - tmp2)*fjac[j-1][1][2])-(tmp1*njac[j-1][1][2]));
				lhs[j][0][2][2]=(((( - tmp2)*fjac[j-1][2][2])-(tmp1*njac[j-1][2][2]))-(tmp1*dy3));
				lhs[j][0][3][2]=((( - tmp2)*fjac[j-1][3][2])-(tmp1*njac[j-1][3][2]));
				lhs[j][0][4][2]=((( - tmp2)*fjac[j-1][4][2])-(tmp1*njac[j-1][4][2]));
				lhs[j][0][0][3]=((( - tmp2)*fjac[j-1][0][3])-(tmp1*njac[j-1][0][3]));
				lhs[j][0][1][3]=((( - tmp2)*fjac[j-1][1][3])-(tmp1*njac[j-1][1][3]));
				lhs[j][0][2][3]=((( - tmp2)*fjac[j-1][2][3])-(tmp1*njac[j-1][2][3]));
				lhs[j][0][3][3]=(((( - tmp2)*fjac[j-1][3][3])-(tmp1*njac[j-1][3][3]))-(tmp1*dy4));
				lhs[j][0][4][3]=((( - tmp2)*fjac[j-1][4][3])-(tmp1*njac[j-1][4][3]));
				lhs[j][0][0][4]=((( - tmp2)*fjac[j-1][0][4])-(tmp1*njac[j-1][0][4]));
				lhs[j][0][1][4]=((( - tmp2)*fjac[j-1][1][4])-(tmp1*njac[j-1][1][4]));
				lhs[j][0][2][4]=((( - tmp2)*fjac[j-1][2][4])-(tmp1*njac[j-1][2][4]));
				lhs[j][0][3][4]=((( - tmp2)*fjac[j-1][3][4])-(tmp1*njac[j-1][3][4]));
				lhs[j][0][4][4]=(((( - tmp2)*fjac[j-1][4][4])-(tmp1*njac[j-1][4][4]))-(tmp1*dy5));
				lhs[j][1][0][0]=((1.0+((tmp1*2.0)*njac[j][0][0]))+((tmp1*2.0)*dy1));
				lhs[j][1][1][0]=((tmp1*2.0)*njac[j][1][0]);
				lhs[j][1][2][0]=((tmp1*2.0)*njac[j][2][0]);
				lhs[j][1][3][0]=((tmp1*2.0)*njac[j][3][0]);
				lhs[j][1][4][0]=((tmp1*2.0)*njac[j][4][0]);
				lhs[j][1][0][1]=((tmp1*2.0)*njac[j][0][1]);
				lhs[j][1][1][1]=((1.0+((tmp1*2.0)*njac[j][1][1]))+((tmp1*2.0)*dy2));
				lhs[j][1][2][1]=((tmp1*2.0)*njac[j][2][1]);
				lhs[j][1][3][1]=((tmp1*2.0)*njac[j][3][1]);
				lhs[j][1][4][1]=((tmp1*2.0)*njac[j][4][1]);
				lhs[j][1][0][2]=((tmp1*2.0)*njac[j][0][2]);
				lhs[j][1][1][2]=((tmp1*2.0)*njac[j][1][2]);
				lhs[j][1][2][2]=((1.0+((tmp1*2.0)*njac[j][2][2]))+((tmp1*2.0)*dy3));
				lhs[j][1][3][2]=((tmp1*2.0)*njac[j][3][2]);
				lhs[j][1][4][2]=((tmp1*2.0)*njac[j][4][2]);
				lhs[j][1][0][3]=((tmp1*2.0)*njac[j][0][3]);
				lhs[j][1][1][3]=((tmp1*2.0)*njac[j][1][3]);
				lhs[j][1][2][3]=((tmp1*2.0)*njac[j][2][3]);
				lhs[j][1][3][3]=((1.0+((tmp1*2.0)*njac[j][3][3]))+((tmp1*2.0)*dy4));
				lhs[j][1][4][3]=((tmp1*2.0)*njac[j][4][3]);
				lhs[j][1][0][4]=((tmp1*2.0)*njac[j][0][4]);
				lhs[j][1][1][4]=((tmp1*2.0)*njac[j][1][4]);
				lhs[j][1][2][4]=((tmp1*2.0)*njac[j][2][4]);
				lhs[j][1][3][4]=((tmp1*2.0)*njac[j][3][4]);
				lhs[j][1][4][4]=((1.0+((tmp1*2.0)*njac[j][4][4]))+((tmp1*2.0)*dy5));
				lhs[j][2][0][0]=(((tmp2*fjac[j+1][0][0])-(tmp1*njac[j+1][0][0]))-(tmp1*dy1));
				lhs[j][2][1][0]=((tmp2*fjac[j+1][1][0])-(tmp1*njac[j+1][1][0]));
				lhs[j][2][2][0]=((tmp2*fjac[j+1][2][0])-(tmp1*njac[j+1][2][0]));
				lhs[j][2][3][0]=((tmp2*fjac[j+1][3][0])-(tmp1*njac[j+1][3][0]));
				lhs[j][2][4][0]=((tmp2*fjac[j+1][4][0])-(tmp1*njac[j+1][4][0]));
				lhs[j][2][0][1]=((tmp2*fjac[j+1][0][1])-(tmp1*njac[j+1][0][1]));
				lhs[j][2][1][1]=(((tmp2*fjac[j+1][1][1])-(tmp1*njac[j+1][1][1]))-(tmp1*dy2));
				lhs[j][2][2][1]=((tmp2*fjac[j+1][2][1])-(tmp1*njac[j+1][2][1]));
				lhs[j][2][3][1]=((tmp2*fjac[j+1][3][1])-(tmp1*njac[j+1][3][1]));
				lhs[j][2][4][1]=((tmp2*fjac[j+1][4][1])-(tmp1*njac[j+1][4][1]));
				lhs[j][2][0][2]=((tmp2*fjac[j+1][0][2])-(tmp1*njac[j+1][0][2]));
				lhs[j][2][1][2]=((tmp2*fjac[j+1][1][2])-(tmp1*njac[j+1][1][2]));
				lhs[j][2][2][2]=(((tmp2*fjac[j+1][2][2])-(tmp1*njac[j+1][2][2]))-(tmp1*dy3));
				lhs[j][2][3][2]=((tmp2*fjac[j+1][3][2])-(tmp1*njac[j+1][3][2]));
				lhs[j][2][4][2]=((tmp2*fjac[j+1][4][2])-(tmp1*njac[j+1][4][2]));
				lhs[j][2][0][3]=((tmp2*fjac[j+1][0][3])-(tmp1*njac[j+1][0][3]));
				lhs[j][2][1][3]=((tmp2*fjac[j+1][1][3])-(tmp1*njac[j+1][1][3]));
				lhs[j][2][2][3]=((tmp2*fjac[j+1][2][3])-(tmp1*njac[j+1][2][3]));
				lhs[j][2][3][3]=(((tmp2*fjac[j+1][3][3])-(tmp1*njac[j+1][3][3]))-(tmp1*dy4));
				lhs[j][2][4][3]=((tmp2*fjac[j+1][4][3])-(tmp1*njac[j+1][4][3]));
				lhs[j][2][0][4]=((tmp2*fjac[j+1][0][4])-(tmp1*njac[j+1][0][4]));
				lhs[j][2][1][4]=((tmp2*fjac[j+1][1][4])-(tmp1*njac[j+1][1][4]));
				lhs[j][2][2][4]=((tmp2*fjac[j+1][2][4])-(tmp1*njac[j+1][2][4]));
				lhs[j][2][3][4]=((tmp2*fjac[j+1][3][4])-(tmp1*njac[j+1][3][4]));
				lhs[j][2][4][4]=(((tmp2*fjac[j+1][4][4])-(tmp1*njac[j+1][4][4]))-(tmp1*dy5));
			}
			binvcrhs(lhs[0][1], lhs[0][2], rhs[k][0][i]);
			//#pragma cetus private(j)
			#pragma loop name y_solve#0#0#2
			for (j=1; j<=(jsize-1); j ++ )
			{
				matvec_sub(lhs[j][0], rhs[k][j-1][i], rhs[k][j][i]);
				matmul_sub(lhs[j][0], lhs[j-1][2], lhs[j][1]);
				binvcrhs(lhs[j][1], lhs[j][2], rhs[k][j][i]);
			}
			matvec_sub(lhs[jsize][0], rhs[k][jsize-1][i], rhs[k][jsize][i]);
			matmul_sub(lhs[jsize][0], lhs[jsize-1][2], lhs[jsize][1]);
			binvrhs(lhs[jsize][1], rhs[k][jsize][i]);
			//#pragma cetus private(j, m, n)
			#pragma loop name y_solve#0#0#3
			for (j=(jsize-1); j>=0; j -- )
			{
				//#pragma cetus private(m, n)
				#pragma loop name y_solve#0#0#3#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m, n)
				*/
				for (m=0; m<5; m ++ )
				{
					//#pragma cetus private(n)
					#pragma loop name y_solve#0#0#3#0#0
					for (n=0; n<5; n ++ )
					{
						rhs[k][j][i][m]=(rhs[k][j][i][m]-(lhs[j][2][n][m]*rhs[k][j+1][i][n]));
					}
				}
			}
		}
	}

	if (timeron)
	{
		timer_stop(7);
	}
	return ;
}


void z_solve()
{
	int i, j, k, m, n, ksize;
	if (timeron)
	{
		timer_start(8);
	}
	ksize=(grid_points[2]-1);

    #pragma experimental section start
	//#pragma cetus private(i, j, k, m, n)
	#pragma loop name z_solve#0
	for (j=1; j<=(grid_points[1]-2); j ++ )
	{
		//#pragma cetus private(i, k, m, n)
		#pragma loop name z_solve#0#0
		for (i=1; i<=(grid_points[0]-2); i ++ )
		{
			//#pragma cetus private(k)
			//#pragma cetus lastprivate(tmp1, tmp2, tmp3)
			#pragma loop name z_solve#0#0#0
			//#pragma cetus parallel
			#pragma omp parallel for private(k) lastprivate(tmp1, tmp2, tmp3)
			for (k=0; k<=ksize; k ++ )
			{
				tmp1=(1.0/u[k][j][i][0]);
				tmp2=(tmp1*tmp1);
				tmp3=(tmp1*tmp2);
				fjac[k][0][0]=0.0;
				fjac[k][1][0]=0.0;
				fjac[k][2][0]=0.0;
				fjac[k][3][0]=1.0;
				fjac[k][4][0]=0.0;
				fjac[k][0][1]=(( - (u[k][j][i][1]*u[k][j][i][3]))*tmp2);
				fjac[k][1][1]=(u[k][j][i][3]*tmp1);
				fjac[k][2][1]=0.0;
				fjac[k][3][1]=(u[k][j][i][1]*tmp1);
				fjac[k][4][1]=0.0;
				fjac[k][0][2]=(( - (u[k][j][i][2]*u[k][j][i][3]))*tmp2);
				fjac[k][1][2]=0.0;
				fjac[k][2][2]=(u[k][j][i][3]*tmp1);
				fjac[k][3][2]=(u[k][j][i][2]*tmp1);
				fjac[k][4][2]=0.0;
				fjac[k][0][3]=(( - ((u[k][j][i][3]*u[k][j][i][3])*tmp2))+(c2*qs[k][j][i]));
				fjac[k][1][3]=((( - c2)*u[k][j][i][1])*tmp1);
				fjac[k][2][3]=((( - c2)*u[k][j][i][2])*tmp1);
				fjac[k][3][3]=(((2.0-c2)*u[k][j][i][3])*tmp1);
				fjac[k][4][3]=c2;
				fjac[k][0][4]=(((((c2*2.0)*square[k][j][i])-(c1*u[k][j][i][4]))*u[k][j][i][3])*tmp2);
				fjac[k][1][4]=((( - c2)*(u[k][j][i][1]*u[k][j][i][3]))*tmp2);
				fjac[k][2][4]=((( - c2)*(u[k][j][i][2]*u[k][j][i][3]))*tmp2);
				fjac[k][3][4]=((c1*(u[k][j][i][4]*tmp1))-(c2*(qs[k][j][i]+((u[k][j][i][3]*u[k][j][i][3])*tmp2))));
				fjac[k][4][4]=((c1*u[k][j][i][3])*tmp1);
				njac[k][0][0]=0.0;
				njac[k][1][0]=0.0;
				njac[k][2][0]=0.0;
				njac[k][3][0]=0.0;
				njac[k][4][0]=0.0;
				njac[k][0][1]=((( - c3c4)*tmp2)*u[k][j][i][1]);
				njac[k][1][1]=(c3c4*tmp1);
				njac[k][2][1]=0.0;
				njac[k][3][1]=0.0;
				njac[k][4][1]=0.0;
				njac[k][0][2]=((( - c3c4)*tmp2)*u[k][j][i][2]);
				njac[k][1][2]=0.0;
				njac[k][2][2]=(c3c4*tmp1);
				njac[k][3][2]=0.0;
				njac[k][4][2]=0.0;
				njac[k][0][3]=(((( - con43)*c3c4)*tmp2)*u[k][j][i][3]);
				njac[k][1][3]=0.0;
				njac[k][2][3]=0.0;
				njac[k][3][3]=(((con43*c3)*c4)*tmp1);
				njac[k][4][3]=0.0;
				njac[k][0][4]=(((((( - (c3c4-c1345))*tmp3)*(u[k][j][i][1]*u[k][j][i][1]))-(((c3c4-c1345)*tmp3)*(u[k][j][i][2]*u[k][j][i][2])))-((((con43*c3c4)-c1345)*tmp3)*(u[k][j][i][3]*u[k][j][i][3])))-((c1345*tmp2)*u[k][j][i][4]));
				njac[k][1][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][1]);
				njac[k][2][4]=(((c3c4-c1345)*tmp2)*u[k][j][i][2]);
				njac[k][3][4]=((((con43*c3c4)-c1345)*tmp2)*u[k][j][i][3]);
				njac[k][4][4]=(c1345*tmp1);
			}
			lhsinit(lhs, ksize);
			//#pragma cetus private(k)
			//#pragma cetus lastprivate(tmp1, tmp2)
			#pragma loop name z_solve#0#0#1
			//#pragma cetus parallel
			#pragma omp parallel for private(k) lastprivate(tmp1, tmp2)
			for (k=1; k<=(ksize-1); k ++ )
			{
				tmp1=(dt*tz1);
				tmp2=(dt*tz2);
				lhs[k][0][0][0]=(((( - tmp2)*fjac[k-1][0][0])-(tmp1*njac[k-1][0][0]))-(tmp1*dz1));
				lhs[k][0][1][0]=((( - tmp2)*fjac[k-1][1][0])-(tmp1*njac[k-1][1][0]));
				lhs[k][0][2][0]=((( - tmp2)*fjac[k-1][2][0])-(tmp1*njac[k-1][2][0]));
				lhs[k][0][3][0]=((( - tmp2)*fjac[k-1][3][0])-(tmp1*njac[k-1][3][0]));
				lhs[k][0][4][0]=((( - tmp2)*fjac[k-1][4][0])-(tmp1*njac[k-1][4][0]));
				lhs[k][0][0][1]=((( - tmp2)*fjac[k-1][0][1])-(tmp1*njac[k-1][0][1]));
				lhs[k][0][1][1]=(((( - tmp2)*fjac[k-1][1][1])-(tmp1*njac[k-1][1][1]))-(tmp1*dz2));
				lhs[k][0][2][1]=((( - tmp2)*fjac[k-1][2][1])-(tmp1*njac[k-1][2][1]));
				lhs[k][0][3][1]=((( - tmp2)*fjac[k-1][3][1])-(tmp1*njac[k-1][3][1]));
				lhs[k][0][4][1]=((( - tmp2)*fjac[k-1][4][1])-(tmp1*njac[k-1][4][1]));
				lhs[k][0][0][2]=((( - tmp2)*fjac[k-1][0][2])-(tmp1*njac[k-1][0][2]));
				lhs[k][0][1][2]=((( - tmp2)*fjac[k-1][1][2])-(tmp1*njac[k-1][1][2]));
				lhs[k][0][2][2]=(((( - tmp2)*fjac[k-1][2][2])-(tmp1*njac[k-1][2][2]))-(tmp1*dz3));
				lhs[k][0][3][2]=((( - tmp2)*fjac[k-1][3][2])-(tmp1*njac[k-1][3][2]));
				lhs[k][0][4][2]=((( - tmp2)*fjac[k-1][4][2])-(tmp1*njac[k-1][4][2]));
				lhs[k][0][0][3]=((( - tmp2)*fjac[k-1][0][3])-(tmp1*njac[k-1][0][3]));
				lhs[k][0][1][3]=((( - tmp2)*fjac[k-1][1][3])-(tmp1*njac[k-1][1][3]));
				lhs[k][0][2][3]=((( - tmp2)*fjac[k-1][2][3])-(tmp1*njac[k-1][2][3]));
				lhs[k][0][3][3]=(((( - tmp2)*fjac[k-1][3][3])-(tmp1*njac[k-1][3][3]))-(tmp1*dz4));
				lhs[k][0][4][3]=((( - tmp2)*fjac[k-1][4][3])-(tmp1*njac[k-1][4][3]));
				lhs[k][0][0][4]=((( - tmp2)*fjac[k-1][0][4])-(tmp1*njac[k-1][0][4]));
				lhs[k][0][1][4]=((( - tmp2)*fjac[k-1][1][4])-(tmp1*njac[k-1][1][4]));
				lhs[k][0][2][4]=((( - tmp2)*fjac[k-1][2][4])-(tmp1*njac[k-1][2][4]));
				lhs[k][0][3][4]=((( - tmp2)*fjac[k-1][3][4])-(tmp1*njac[k-1][3][4]));
				lhs[k][0][4][4]=(((( - tmp2)*fjac[k-1][4][4])-(tmp1*njac[k-1][4][4]))-(tmp1*dz5));
				lhs[k][1][0][0]=((1.0+((tmp1*2.0)*njac[k][0][0]))+((tmp1*2.0)*dz1));
				lhs[k][1][1][0]=((tmp1*2.0)*njac[k][1][0]);
				lhs[k][1][2][0]=((tmp1*2.0)*njac[k][2][0]);
				lhs[k][1][3][0]=((tmp1*2.0)*njac[k][3][0]);
				lhs[k][1][4][0]=((tmp1*2.0)*njac[k][4][0]);
				lhs[k][1][0][1]=((tmp1*2.0)*njac[k][0][1]);
				lhs[k][1][1][1]=((1.0+((tmp1*2.0)*njac[k][1][1]))+((tmp1*2.0)*dz2));
				lhs[k][1][2][1]=((tmp1*2.0)*njac[k][2][1]);
				lhs[k][1][3][1]=((tmp1*2.0)*njac[k][3][1]);
				lhs[k][1][4][1]=((tmp1*2.0)*njac[k][4][1]);
				lhs[k][1][0][2]=((tmp1*2.0)*njac[k][0][2]);
				lhs[k][1][1][2]=((tmp1*2.0)*njac[k][1][2]);
				lhs[k][1][2][2]=((1.0+((tmp1*2.0)*njac[k][2][2]))+((tmp1*2.0)*dz3));
				lhs[k][1][3][2]=((tmp1*2.0)*njac[k][3][2]);
				lhs[k][1][4][2]=((tmp1*2.0)*njac[k][4][2]);
				lhs[k][1][0][3]=((tmp1*2.0)*njac[k][0][3]);
				lhs[k][1][1][3]=((tmp1*2.0)*njac[k][1][3]);
				lhs[k][1][2][3]=((tmp1*2.0)*njac[k][2][3]);
				lhs[k][1][3][3]=((1.0+((tmp1*2.0)*njac[k][3][3]))+((tmp1*2.0)*dz4));
				lhs[k][1][4][3]=((tmp1*2.0)*njac[k][4][3]);
				lhs[k][1][0][4]=((tmp1*2.0)*njac[k][0][4]);
				lhs[k][1][1][4]=((tmp1*2.0)*njac[k][1][4]);
				lhs[k][1][2][4]=((tmp1*2.0)*njac[k][2][4]);
				lhs[k][1][3][4]=((tmp1*2.0)*njac[k][3][4]);
				lhs[k][1][4][4]=((1.0+((tmp1*2.0)*njac[k][4][4]))+((tmp1*2.0)*dz5));
				lhs[k][2][0][0]=(((tmp2*fjac[k+1][0][0])-(tmp1*njac[k+1][0][0]))-(tmp1*dz1));
				lhs[k][2][1][0]=((tmp2*fjac[k+1][1][0])-(tmp1*njac[k+1][1][0]));
				lhs[k][2][2][0]=((tmp2*fjac[k+1][2][0])-(tmp1*njac[k+1][2][0]));
				lhs[k][2][3][0]=((tmp2*fjac[k+1][3][0])-(tmp1*njac[k+1][3][0]));
				lhs[k][2][4][0]=((tmp2*fjac[k+1][4][0])-(tmp1*njac[k+1][4][0]));
				lhs[k][2][0][1]=((tmp2*fjac[k+1][0][1])-(tmp1*njac[k+1][0][1]));
				lhs[k][2][1][1]=(((tmp2*fjac[k+1][1][1])-(tmp1*njac[k+1][1][1]))-(tmp1*dz2));
				lhs[k][2][2][1]=((tmp2*fjac[k+1][2][1])-(tmp1*njac[k+1][2][1]));
				lhs[k][2][3][1]=((tmp2*fjac[k+1][3][1])-(tmp1*njac[k+1][3][1]));
				lhs[k][2][4][1]=((tmp2*fjac[k+1][4][1])-(tmp1*njac[k+1][4][1]));
				lhs[k][2][0][2]=((tmp2*fjac[k+1][0][2])-(tmp1*njac[k+1][0][2]));
				lhs[k][2][1][2]=((tmp2*fjac[k+1][1][2])-(tmp1*njac[k+1][1][2]));
				lhs[k][2][2][2]=(((tmp2*fjac[k+1][2][2])-(tmp1*njac[k+1][2][2]))-(tmp1*dz3));
				lhs[k][2][3][2]=((tmp2*fjac[k+1][3][2])-(tmp1*njac[k+1][3][2]));
				lhs[k][2][4][2]=((tmp2*fjac[k+1][4][2])-(tmp1*njac[k+1][4][2]));
				lhs[k][2][0][3]=((tmp2*fjac[k+1][0][3])-(tmp1*njac[k+1][0][3]));
				lhs[k][2][1][3]=((tmp2*fjac[k+1][1][3])-(tmp1*njac[k+1][1][3]));
				lhs[k][2][2][3]=((tmp2*fjac[k+1][2][3])-(tmp1*njac[k+1][2][3]));
				lhs[k][2][3][3]=(((tmp2*fjac[k+1][3][3])-(tmp1*njac[k+1][3][3]))-(tmp1*dz4));
				lhs[k][2][4][3]=((tmp2*fjac[k+1][4][3])-(tmp1*njac[k+1][4][3]));
				lhs[k][2][0][4]=((tmp2*fjac[k+1][0][4])-(tmp1*njac[k+1][0][4]));
				lhs[k][2][1][4]=((tmp2*fjac[k+1][1][4])-(tmp1*njac[k+1][1][4]));
				lhs[k][2][2][4]=((tmp2*fjac[k+1][2][4])-(tmp1*njac[k+1][2][4]));
				lhs[k][2][3][4]=((tmp2*fjac[k+1][3][4])-(tmp1*njac[k+1][3][4]));
				lhs[k][2][4][4]=(((tmp2*fjac[k+1][4][4])-(tmp1*njac[k+1][4][4]))-(tmp1*dz5));
			}
			binvcrhs(lhs[0][1], lhs[0][2], rhs[0][j][i]);
			//#pragma cetus private(k)
			#pragma loop name z_solve#0#0#2
			for (k=1; k<=(ksize-1); k ++ )
			{
				matvec_sub(lhs[k][0], rhs[k-1][j][i], rhs[k][j][i]);
				matmul_sub(lhs[k][0], lhs[k-1][2], lhs[k][1]);
				binvcrhs(lhs[k][1], lhs[k][2], rhs[k][j][i]);
			}
			matvec_sub(lhs[ksize][0], rhs[ksize-1][j][i], rhs[ksize][j][i]);
			matmul_sub(lhs[ksize][0], lhs[ksize-1][2], lhs[ksize][1]);
			binvrhs(lhs[ksize][1], rhs[ksize][j][i]);
			//#pragma cetus private(k, m, n)
			#pragma loop name z_solve#0#0#3
			for (k=(ksize-1); k>=0; k -- )
			{
				//#pragma cetus private(m, n)
				#pragma loop name z_solve#0#0#3#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(m, n)
				*/
				for (m=0; m<5; m ++ )
				{
					//#pragma cetus private(n)
					#pragma loop name z_solve#0#0#3#0#0
					for (n=0; n<5; n ++ )
					{
						rhs[k][j][i][m]=(rhs[k][j][i][m]-(lhs[k][2][n][m]*rhs[k+1][j][i][n]));
					}
				}
			}
		}
	}
	#pragma experimental section stop
	if (timeron)
	{
		timer_stop(8);
	}
	return ;
}

void matvec_sub(double ablock[5][5], double avec[5], double bvec[5])
{
	bvec[0]=(((((bvec[0]-(ablock[0][0]*avec[0]))-(ablock[1][0]*avec[1]))-(ablock[2][0]*avec[2]))-(ablock[3][0]*avec[3]))-(ablock[4][0]*avec[4]));
	bvec[1]=(((((bvec[1]-(ablock[0][1]*avec[0]))-(ablock[1][1]*avec[1]))-(ablock[2][1]*avec[2]))-(ablock[3][1]*avec[3]))-(ablock[4][1]*avec[4]));
	bvec[2]=(((((bvec[2]-(ablock[0][2]*avec[0]))-(ablock[1][2]*avec[1]))-(ablock[2][2]*avec[2]))-(ablock[3][2]*avec[3]))-(ablock[4][2]*avec[4]));
	bvec[3]=(((((bvec[3]-(ablock[0][3]*avec[0]))-(ablock[1][3]*avec[1]))-(ablock[2][3]*avec[2]))-(ablock[3][3]*avec[3]))-(ablock[4][3]*avec[4]));
	bvec[4]=(((((bvec[4]-(ablock[0][4]*avec[0]))-(ablock[1][4]*avec[1]))-(ablock[2][4]*avec[2]))-(ablock[3][4]*avec[3]))-(ablock[4][4]*avec[4]));
	return ;
}

void matmul_sub(double ablock[5][5], double bblock[5][5], double cblock[5][5])
{
	cblock[0][0]=(((((cblock[0][0]-(ablock[0][0]*bblock[0][0]))-(ablock[1][0]*bblock[0][1]))-(ablock[2][0]*bblock[0][2]))-(ablock[3][0]*bblock[0][3]))-(ablock[4][0]*bblock[0][4]));
	cblock[0][1]=(((((cblock[0][1]-(ablock[0][1]*bblock[0][0]))-(ablock[1][1]*bblock[0][1]))-(ablock[2][1]*bblock[0][2]))-(ablock[3][1]*bblock[0][3]))-(ablock[4][1]*bblock[0][4]));
	cblock[0][2]=(((((cblock[0][2]-(ablock[0][2]*bblock[0][0]))-(ablock[1][2]*bblock[0][1]))-(ablock[2][2]*bblock[0][2]))-(ablock[3][2]*bblock[0][3]))-(ablock[4][2]*bblock[0][4]));
	cblock[0][3]=(((((cblock[0][3]-(ablock[0][3]*bblock[0][0]))-(ablock[1][3]*bblock[0][1]))-(ablock[2][3]*bblock[0][2]))-(ablock[3][3]*bblock[0][3]))-(ablock[4][3]*bblock[0][4]));
	cblock[0][4]=(((((cblock[0][4]-(ablock[0][4]*bblock[0][0]))-(ablock[1][4]*bblock[0][1]))-(ablock[2][4]*bblock[0][2]))-(ablock[3][4]*bblock[0][3]))-(ablock[4][4]*bblock[0][4]));
	cblock[1][0]=(((((cblock[1][0]-(ablock[0][0]*bblock[1][0]))-(ablock[1][0]*bblock[1][1]))-(ablock[2][0]*bblock[1][2]))-(ablock[3][0]*bblock[1][3]))-(ablock[4][0]*bblock[1][4]));
	cblock[1][1]=(((((cblock[1][1]-(ablock[0][1]*bblock[1][0]))-(ablock[1][1]*bblock[1][1]))-(ablock[2][1]*bblock[1][2]))-(ablock[3][1]*bblock[1][3]))-(ablock[4][1]*bblock[1][4]));
	cblock[1][2]=(((((cblock[1][2]-(ablock[0][2]*bblock[1][0]))-(ablock[1][2]*bblock[1][1]))-(ablock[2][2]*bblock[1][2]))-(ablock[3][2]*bblock[1][3]))-(ablock[4][2]*bblock[1][4]));
	cblock[1][3]=(((((cblock[1][3]-(ablock[0][3]*bblock[1][0]))-(ablock[1][3]*bblock[1][1]))-(ablock[2][3]*bblock[1][2]))-(ablock[3][3]*bblock[1][3]))-(ablock[4][3]*bblock[1][4]));
	cblock[1][4]=(((((cblock[1][4]-(ablock[0][4]*bblock[1][0]))-(ablock[1][4]*bblock[1][1]))-(ablock[2][4]*bblock[1][2]))-(ablock[3][4]*bblock[1][3]))-(ablock[4][4]*bblock[1][4]));
	cblock[2][0]=(((((cblock[2][0]-(ablock[0][0]*bblock[2][0]))-(ablock[1][0]*bblock[2][1]))-(ablock[2][0]*bblock[2][2]))-(ablock[3][0]*bblock[2][3]))-(ablock[4][0]*bblock[2][4]));
	cblock[2][1]=(((((cblock[2][1]-(ablock[0][1]*bblock[2][0]))-(ablock[1][1]*bblock[2][1]))-(ablock[2][1]*bblock[2][2]))-(ablock[3][1]*bblock[2][3]))-(ablock[4][1]*bblock[2][4]));
	cblock[2][2]=(((((cblock[2][2]-(ablock[0][2]*bblock[2][0]))-(ablock[1][2]*bblock[2][1]))-(ablock[2][2]*bblock[2][2]))-(ablock[3][2]*bblock[2][3]))-(ablock[4][2]*bblock[2][4]));
	cblock[2][3]=(((((cblock[2][3]-(ablock[0][3]*bblock[2][0]))-(ablock[1][3]*bblock[2][1]))-(ablock[2][3]*bblock[2][2]))-(ablock[3][3]*bblock[2][3]))-(ablock[4][3]*bblock[2][4]));
	cblock[2][4]=(((((cblock[2][4]-(ablock[0][4]*bblock[2][0]))-(ablock[1][4]*bblock[2][1]))-(ablock[2][4]*bblock[2][2]))-(ablock[3][4]*bblock[2][3]))-(ablock[4][4]*bblock[2][4]));
	cblock[3][0]=(((((cblock[3][0]-(ablock[0][0]*bblock[3][0]))-(ablock[1][0]*bblock[3][1]))-(ablock[2][0]*bblock[3][2]))-(ablock[3][0]*bblock[3][3]))-(ablock[4][0]*bblock[3][4]));
	cblock[3][1]=(((((cblock[3][1]-(ablock[0][1]*bblock[3][0]))-(ablock[1][1]*bblock[3][1]))-(ablock[2][1]*bblock[3][2]))-(ablock[3][1]*bblock[3][3]))-(ablock[4][1]*bblock[3][4]));
	cblock[3][2]=(((((cblock[3][2]-(ablock[0][2]*bblock[3][0]))-(ablock[1][2]*bblock[3][1]))-(ablock[2][2]*bblock[3][2]))-(ablock[3][2]*bblock[3][3]))-(ablock[4][2]*bblock[3][4]));
	cblock[3][3]=(((((cblock[3][3]-(ablock[0][3]*bblock[3][0]))-(ablock[1][3]*bblock[3][1]))-(ablock[2][3]*bblock[3][2]))-(ablock[3][3]*bblock[3][3]))-(ablock[4][3]*bblock[3][4]));
	cblock[3][4]=(((((cblock[3][4]-(ablock[0][4]*bblock[3][0]))-(ablock[1][4]*bblock[3][1]))-(ablock[2][4]*bblock[3][2]))-(ablock[3][4]*bblock[3][3]))-(ablock[4][4]*bblock[3][4]));
	cblock[4][0]=(((((cblock[4][0]-(ablock[0][0]*bblock[4][0]))-(ablock[1][0]*bblock[4][1]))-(ablock[2][0]*bblock[4][2]))-(ablock[3][0]*bblock[4][3]))-(ablock[4][0]*bblock[4][4]));
	cblock[4][1]=(((((cblock[4][1]-(ablock[0][1]*bblock[4][0]))-(ablock[1][1]*bblock[4][1]))-(ablock[2][1]*bblock[4][2]))-(ablock[3][1]*bblock[4][3]))-(ablock[4][1]*bblock[4][4]));
	cblock[4][2]=(((((cblock[4][2]-(ablock[0][2]*bblock[4][0]))-(ablock[1][2]*bblock[4][1]))-(ablock[2][2]*bblock[4][2]))-(ablock[3][2]*bblock[4][3]))-(ablock[4][2]*bblock[4][4]));
	cblock[4][3]=(((((cblock[4][3]-(ablock[0][3]*bblock[4][0]))-(ablock[1][3]*bblock[4][1]))-(ablock[2][3]*bblock[4][2]))-(ablock[3][3]*bblock[4][3]))-(ablock[4][3]*bblock[4][4]));
	cblock[4][4]=(((((cblock[4][4]-(ablock[0][4]*bblock[4][0]))-(ablock[1][4]*bblock[4][1]))-(ablock[2][4]*bblock[4][2]))-(ablock[3][4]*bblock[4][3]))-(ablock[4][4]*bblock[4][4]));
	return ;
}

void binvcrhs(double lhs[5][5], double c[5][5], double r[5])
{
	double pivot, coeff;
	pivot=(1.0/lhs[0][0]);
	lhs[1][0]=(lhs[1][0]*pivot);
	lhs[2][0]=(lhs[2][0]*pivot);
	lhs[3][0]=(lhs[3][0]*pivot);
	lhs[4][0]=(lhs[4][0]*pivot);
	c[0][0]=(c[0][0]*pivot);
	c[1][0]=(c[1][0]*pivot);
	c[2][0]=(c[2][0]*pivot);
	c[3][0]=(c[3][0]*pivot);
	c[4][0]=(c[4][0]*pivot);
	r[0]=(r[0]*pivot);
	coeff=lhs[0][1];
	lhs[1][1]=(lhs[1][1]-(coeff*lhs[1][0]));
	lhs[2][1]=(lhs[2][1]-(coeff*lhs[2][0]));
	lhs[3][1]=(lhs[3][1]-(coeff*lhs[3][0]));
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][0]));
	c[0][1]=(c[0][1]-(coeff*c[0][0]));
	c[1][1]=(c[1][1]-(coeff*c[1][0]));
	c[2][1]=(c[2][1]-(coeff*c[2][0]));
	c[3][1]=(c[3][1]-(coeff*c[3][0]));
	c[4][1]=(c[4][1]-(coeff*c[4][0]));
	r[1]=(r[1]-(coeff*r[0]));
	coeff=lhs[0][2];
	lhs[1][2]=(lhs[1][2]-(coeff*lhs[1][0]));
	lhs[2][2]=(lhs[2][2]-(coeff*lhs[2][0]));
	lhs[3][2]=(lhs[3][2]-(coeff*lhs[3][0]));
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][0]));
	c[0][2]=(c[0][2]-(coeff*c[0][0]));
	c[1][2]=(c[1][2]-(coeff*c[1][0]));
	c[2][2]=(c[2][2]-(coeff*c[2][0]));
	c[3][2]=(c[3][2]-(coeff*c[3][0]));
	c[4][2]=(c[4][2]-(coeff*c[4][0]));
	r[2]=(r[2]-(coeff*r[0]));
	coeff=lhs[0][3];
	lhs[1][3]=(lhs[1][3]-(coeff*lhs[1][0]));
	lhs[2][3]=(lhs[2][3]-(coeff*lhs[2][0]));
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][0]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][0]));
	c[0][3]=(c[0][3]-(coeff*c[0][0]));
	c[1][3]=(c[1][3]-(coeff*c[1][0]));
	c[2][3]=(c[2][3]-(coeff*c[2][0]));
	c[3][3]=(c[3][3]-(coeff*c[3][0]));
	c[4][3]=(c[4][3]-(coeff*c[4][0]));
	r[3]=(r[3]-(coeff*r[0]));
	coeff=lhs[0][4];
	lhs[1][4]=(lhs[1][4]-(coeff*lhs[1][0]));
	lhs[2][4]=(lhs[2][4]-(coeff*lhs[2][0]));
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][0]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][0]));
	c[0][4]=(c[0][4]-(coeff*c[0][0]));
	c[1][4]=(c[1][4]-(coeff*c[1][0]));
	c[2][4]=(c[2][4]-(coeff*c[2][0]));
	c[3][4]=(c[3][4]-(coeff*c[3][0]));
	c[4][4]=(c[4][4]-(coeff*c[4][0]));
	r[4]=(r[4]-(coeff*r[0]));
	pivot=(1.0/lhs[1][1]);
	lhs[2][1]=(lhs[2][1]*pivot);
	lhs[3][1]=(lhs[3][1]*pivot);
	lhs[4][1]=(lhs[4][1]*pivot);
	c[0][1]=(c[0][1]*pivot);
	c[1][1]=(c[1][1]*pivot);
	c[2][1]=(c[2][1]*pivot);
	c[3][1]=(c[3][1]*pivot);
	c[4][1]=(c[4][1]*pivot);
	r[1]=(r[1]*pivot);
	coeff=lhs[1][0];
	lhs[2][0]=(lhs[2][0]-(coeff*lhs[2][1]));
	lhs[3][0]=(lhs[3][0]-(coeff*lhs[3][1]));
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][1]));
	c[0][0]=(c[0][0]-(coeff*c[0][1]));
	c[1][0]=(c[1][0]-(coeff*c[1][1]));
	c[2][0]=(c[2][0]-(coeff*c[2][1]));
	c[3][0]=(c[3][0]-(coeff*c[3][1]));
	c[4][0]=(c[4][0]-(coeff*c[4][1]));
	r[0]=(r[0]-(coeff*r[1]));
	coeff=lhs[1][2];
	lhs[2][2]=(lhs[2][2]-(coeff*lhs[2][1]));
	lhs[3][2]=(lhs[3][2]-(coeff*lhs[3][1]));
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][1]));
	c[0][2]=(c[0][2]-(coeff*c[0][1]));
	c[1][2]=(c[1][2]-(coeff*c[1][1]));
	c[2][2]=(c[2][2]-(coeff*c[2][1]));
	c[3][2]=(c[3][2]-(coeff*c[3][1]));
	c[4][2]=(c[4][2]-(coeff*c[4][1]));
	r[2]=(r[2]-(coeff*r[1]));
	coeff=lhs[1][3];
	lhs[2][3]=(lhs[2][3]-(coeff*lhs[2][1]));
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][1]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][1]));
	c[0][3]=(c[0][3]-(coeff*c[0][1]));
	c[1][3]=(c[1][3]-(coeff*c[1][1]));
	c[2][3]=(c[2][3]-(coeff*c[2][1]));
	c[3][3]=(c[3][3]-(coeff*c[3][1]));
	c[4][3]=(c[4][3]-(coeff*c[4][1]));
	r[3]=(r[3]-(coeff*r[1]));
	coeff=lhs[1][4];
	lhs[2][4]=(lhs[2][4]-(coeff*lhs[2][1]));
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][1]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][1]));
	c[0][4]=(c[0][4]-(coeff*c[0][1]));
	c[1][4]=(c[1][4]-(coeff*c[1][1]));
	c[2][4]=(c[2][4]-(coeff*c[2][1]));
	c[3][4]=(c[3][4]-(coeff*c[3][1]));
	c[4][4]=(c[4][4]-(coeff*c[4][1]));
	r[4]=(r[4]-(coeff*r[1]));
	pivot=(1.0/lhs[2][2]);
	lhs[3][2]=(lhs[3][2]*pivot);
	lhs[4][2]=(lhs[4][2]*pivot);
	c[0][2]=(c[0][2]*pivot);
	c[1][2]=(c[1][2]*pivot);
	c[2][2]=(c[2][2]*pivot);
	c[3][2]=(c[3][2]*pivot);
	c[4][2]=(c[4][2]*pivot);
	r[2]=(r[2]*pivot);
	coeff=lhs[2][0];
	lhs[3][0]=(lhs[3][0]-(coeff*lhs[3][2]));
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][2]));
	c[0][0]=(c[0][0]-(coeff*c[0][2]));
	c[1][0]=(c[1][0]-(coeff*c[1][2]));
	c[2][0]=(c[2][0]-(coeff*c[2][2]));
	c[3][0]=(c[3][0]-(coeff*c[3][2]));
	c[4][0]=(c[4][0]-(coeff*c[4][2]));
	r[0]=(r[0]-(coeff*r[2]));
	coeff=lhs[2][1];
	lhs[3][1]=(lhs[3][1]-(coeff*lhs[3][2]));
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][2]));
	c[0][1]=(c[0][1]-(coeff*c[0][2]));
	c[1][1]=(c[1][1]-(coeff*c[1][2]));
	c[2][1]=(c[2][1]-(coeff*c[2][2]));
	c[3][1]=(c[3][1]-(coeff*c[3][2]));
	c[4][1]=(c[4][1]-(coeff*c[4][2]));
	r[1]=(r[1]-(coeff*r[2]));
	coeff=lhs[2][3];
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][2]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][2]));
	c[0][3]=(c[0][3]-(coeff*c[0][2]));
	c[1][3]=(c[1][3]-(coeff*c[1][2]));
	c[2][3]=(c[2][3]-(coeff*c[2][2]));
	c[3][3]=(c[3][3]-(coeff*c[3][2]));
	c[4][3]=(c[4][3]-(coeff*c[4][2]));
	r[3]=(r[3]-(coeff*r[2]));
	coeff=lhs[2][4];
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][2]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][2]));
	c[0][4]=(c[0][4]-(coeff*c[0][2]));
	c[1][4]=(c[1][4]-(coeff*c[1][2]));
	c[2][4]=(c[2][4]-(coeff*c[2][2]));
	c[3][4]=(c[3][4]-(coeff*c[3][2]));
	c[4][4]=(c[4][4]-(coeff*c[4][2]));
	r[4]=(r[4]-(coeff*r[2]));
	pivot=(1.0/lhs[3][3]);
	lhs[4][3]=(lhs[4][3]*pivot);
	c[0][3]=(c[0][3]*pivot);
	c[1][3]=(c[1][3]*pivot);
	c[2][3]=(c[2][3]*pivot);
	c[3][3]=(c[3][3]*pivot);
	c[4][3]=(c[4][3]*pivot);
	r[3]=(r[3]*pivot);
	coeff=lhs[3][0];
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][3]));
	c[0][0]=(c[0][0]-(coeff*c[0][3]));
	c[1][0]=(c[1][0]-(coeff*c[1][3]));
	c[2][0]=(c[2][0]-(coeff*c[2][3]));
	c[3][0]=(c[3][0]-(coeff*c[3][3]));
	c[4][0]=(c[4][0]-(coeff*c[4][3]));
	r[0]=(r[0]-(coeff*r[3]));
	coeff=lhs[3][1];
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][3]));
	c[0][1]=(c[0][1]-(coeff*c[0][3]));
	c[1][1]=(c[1][1]-(coeff*c[1][3]));
	c[2][1]=(c[2][1]-(coeff*c[2][3]));
	c[3][1]=(c[3][1]-(coeff*c[3][3]));
	c[4][1]=(c[4][1]-(coeff*c[4][3]));
	r[1]=(r[1]-(coeff*r[3]));
	coeff=lhs[3][2];
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][3]));
	c[0][2]=(c[0][2]-(coeff*c[0][3]));
	c[1][2]=(c[1][2]-(coeff*c[1][3]));
	c[2][2]=(c[2][2]-(coeff*c[2][3]));
	c[3][2]=(c[3][2]-(coeff*c[3][3]));
	c[4][2]=(c[4][2]-(coeff*c[4][3]));
	r[2]=(r[2]-(coeff*r[3]));
	coeff=lhs[3][4];
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][3]));
	c[0][4]=(c[0][4]-(coeff*c[0][3]));
	c[1][4]=(c[1][4]-(coeff*c[1][3]));
	c[2][4]=(c[2][4]-(coeff*c[2][3]));
	c[3][4]=(c[3][4]-(coeff*c[3][3]));
	c[4][4]=(c[4][4]-(coeff*c[4][3]));
	r[4]=(r[4]-(coeff*r[3]));
	pivot=(1.0/lhs[4][4]);
	c[0][4]=(c[0][4]*pivot);
	c[1][4]=(c[1][4]*pivot);
	c[2][4]=(c[2][4]*pivot);
	c[3][4]=(c[3][4]*pivot);
	c[4][4]=(c[4][4]*pivot);
	r[4]=(r[4]*pivot);
	coeff=lhs[4][0];
	c[0][0]=(c[0][0]-(coeff*c[0][4]));
	c[1][0]=(c[1][0]-(coeff*c[1][4]));
	c[2][0]=(c[2][0]-(coeff*c[2][4]));
	c[3][0]=(c[3][0]-(coeff*c[3][4]));
	c[4][0]=(c[4][0]-(coeff*c[4][4]));
	r[0]=(r[0]-(coeff*r[4]));
	coeff=lhs[4][1];
	c[0][1]=(c[0][1]-(coeff*c[0][4]));
	c[1][1]=(c[1][1]-(coeff*c[1][4]));
	c[2][1]=(c[2][1]-(coeff*c[2][4]));
	c[3][1]=(c[3][1]-(coeff*c[3][4]));
	c[4][1]=(c[4][1]-(coeff*c[4][4]));
	r[1]=(r[1]-(coeff*r[4]));
	coeff=lhs[4][2];
	c[0][2]=(c[0][2]-(coeff*c[0][4]));
	c[1][2]=(c[1][2]-(coeff*c[1][4]));
	c[2][2]=(c[2][2]-(coeff*c[2][4]));
	c[3][2]=(c[3][2]-(coeff*c[3][4]));
	c[4][2]=(c[4][2]-(coeff*c[4][4]));
	r[2]=(r[2]-(coeff*r[4]));
	coeff=lhs[4][3];
	c[0][3]=(c[0][3]-(coeff*c[0][4]));
	c[1][3]=(c[1][3]-(coeff*c[1][4]));
	c[2][3]=(c[2][3]-(coeff*c[2][4]));
	c[3][3]=(c[3][3]-(coeff*c[3][4]));
	c[4][3]=(c[4][3]-(coeff*c[4][4]));
	r[3]=(r[3]-(coeff*r[4]));
	return ;
}

void binvrhs(double lhs[5][5], double r[5])
{
	double pivot, coeff;
	pivot=(1.0/lhs[0][0]);
	lhs[1][0]=(lhs[1][0]*pivot);
	lhs[2][0]=(lhs[2][0]*pivot);
	lhs[3][0]=(lhs[3][0]*pivot);
	lhs[4][0]=(lhs[4][0]*pivot);
	r[0]=(r[0]*pivot);
	coeff=lhs[0][1];
	lhs[1][1]=(lhs[1][1]-(coeff*lhs[1][0]));
	lhs[2][1]=(lhs[2][1]-(coeff*lhs[2][0]));
	lhs[3][1]=(lhs[3][1]-(coeff*lhs[3][0]));
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][0]));
	r[1]=(r[1]-(coeff*r[0]));
	coeff=lhs[0][2];
	lhs[1][2]=(lhs[1][2]-(coeff*lhs[1][0]));
	lhs[2][2]=(lhs[2][2]-(coeff*lhs[2][0]));
	lhs[3][2]=(lhs[3][2]-(coeff*lhs[3][0]));
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][0]));
	r[2]=(r[2]-(coeff*r[0]));
	coeff=lhs[0][3];
	lhs[1][3]=(lhs[1][3]-(coeff*lhs[1][0]));
	lhs[2][3]=(lhs[2][3]-(coeff*lhs[2][0]));
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][0]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][0]));
	r[3]=(r[3]-(coeff*r[0]));
	coeff=lhs[0][4];
	lhs[1][4]=(lhs[1][4]-(coeff*lhs[1][0]));
	lhs[2][4]=(lhs[2][4]-(coeff*lhs[2][0]));
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][0]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][0]));
	r[4]=(r[4]-(coeff*r[0]));
	pivot=(1.0/lhs[1][1]);
	lhs[2][1]=(lhs[2][1]*pivot);
	lhs[3][1]=(lhs[3][1]*pivot);
	lhs[4][1]=(lhs[4][1]*pivot);
	r[1]=(r[1]*pivot);
	coeff=lhs[1][0];
	lhs[2][0]=(lhs[2][0]-(coeff*lhs[2][1]));
	lhs[3][0]=(lhs[3][0]-(coeff*lhs[3][1]));
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][1]));
	r[0]=(r[0]-(coeff*r[1]));
	coeff=lhs[1][2];
	lhs[2][2]=(lhs[2][2]-(coeff*lhs[2][1]));
	lhs[3][2]=(lhs[3][2]-(coeff*lhs[3][1]));
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][1]));
	r[2]=(r[2]-(coeff*r[1]));
	coeff=lhs[1][3];
	lhs[2][3]=(lhs[2][3]-(coeff*lhs[2][1]));
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][1]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][1]));
	r[3]=(r[3]-(coeff*r[1]));
	coeff=lhs[1][4];
	lhs[2][4]=(lhs[2][4]-(coeff*lhs[2][1]));
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][1]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][1]));
	r[4]=(r[4]-(coeff*r[1]));
	pivot=(1.0/lhs[2][2]);
	lhs[3][2]=(lhs[3][2]*pivot);
	lhs[4][2]=(lhs[4][2]*pivot);
	r[2]=(r[2]*pivot);
	coeff=lhs[2][0];
	lhs[3][0]=(lhs[3][0]-(coeff*lhs[3][2]));
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][2]));
	r[0]=(r[0]-(coeff*r[2]));
	coeff=lhs[2][1];
	lhs[3][1]=(lhs[3][1]-(coeff*lhs[3][2]));
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][2]));
	r[1]=(r[1]-(coeff*r[2]));
	coeff=lhs[2][3];
	lhs[3][3]=(lhs[3][3]-(coeff*lhs[3][2]));
	lhs[4][3]=(lhs[4][3]-(coeff*lhs[4][2]));
	r[3]=(r[3]-(coeff*r[2]));
	coeff=lhs[2][4];
	lhs[3][4]=(lhs[3][4]-(coeff*lhs[3][2]));
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][2]));
	r[4]=(r[4]-(coeff*r[2]));
	pivot=(1.0/lhs[3][3]);
	lhs[4][3]=(lhs[4][3]*pivot);
	r[3]=(r[3]*pivot);
	coeff=lhs[3][0];
	lhs[4][0]=(lhs[4][0]-(coeff*lhs[4][3]));
	r[0]=(r[0]-(coeff*r[3]));
	coeff=lhs[3][1];
	lhs[4][1]=(lhs[4][1]-(coeff*lhs[4][3]));
	r[1]=(r[1]-(coeff*r[3]));
	coeff=lhs[3][2];
	lhs[4][2]=(lhs[4][2]-(coeff*lhs[4][3]));
	r[2]=(r[2]-(coeff*r[3]));
	coeff=lhs[3][4];
	lhs[4][4]=(lhs[4][4]-(coeff*lhs[4][3]));
	r[4]=(r[4]-(coeff*r[3]));
	pivot=(1.0/lhs[4][4]);
	r[4]=(r[4]*pivot);
	coeff=lhs[4][0];
	r[0]=(r[0]-(coeff*r[4]));
	coeff=lhs[4][1];
	r[1]=(r[1]-(coeff*r[4]));
	coeff=lhs[4][2];
	r[2]=(r[2]-(coeff*r[4]));
	coeff=lhs[4][3];
	r[3]=(r[3]-(coeff*r[4]));
	return ;
}

void add()
{
	int i, j, k, m;
	if (timeron)
	{
		timer_start(11);
	}
	//#pragma cetus private(i, j, k, m)
	#pragma loop name add#0
	//#pragma cetus parallel
	#pragma omp parallel for private(i, j, k, m)
	for (k=1; k<=(grid_points[2]-2); k ++ )
	{
		//#pragma cetus private(i, j, m)
		#pragma loop name add#0#0
		for (j=1; j<=(grid_points[1]-2); j ++ )
		{
			//#pragma cetus private(i, m)
			#pragma loop name add#0#0#0
			for (i=1; i<=(grid_points[0]-2); i ++ )
			{
				//#pragma cetus private(m)
				#pragma loop name add#0#0#0#0
				for (m=0; m<5; m ++ )
				{
					u[k][j][i][m]=(u[k][j][i][m]+rhs[k][j][i][m]);
				}
			}
		}
	}
	if (timeron)
	{
		timer_stop(11);
	}
	return ;
}

void verify(int no_time_steps, char * Class, logical * verified)
{
	double xcrref[5], xceref[5], xcrdif[5], xcedif[5];
	double epsilon, xce[5], xcr[5], dtref = 0.0;
	int m;
	epsilon=1.0E-8;
	error_norm(xce);
	compute_rhs();
	rhs_norm(xcr);
	//#pragma cetus private(m)
	#pragma loop name verify#0
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		xcr[m]=(xcr[m]/dt);
	}
	( * Class)='U';
	( * verified)=true;
	//#pragma cetus private(m)
	#pragma loop name verify#1
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		xcrref[m]=1.0;
		xceref[m]=1.0;
	}
	if ((((grid_points[0]==12)&&(grid_points[1]==12))&&(grid_points[2]==12))&&(no_time_steps==60))
	{
		( * Class)='S';
		dtref=0.01;
		xcrref[0]=0.17034283709541312;
		xcrref[1]=0.012975252070034096;
		xcrref[2]=0.032527926989486054;
		xcrref[3]=0.0264364212751668;
		xcrref[4]=0.1921178413174443;
		xceref[0]=4.997691334581158E-4;
		xceref[1]=4.519566678296193E-5;
		xceref[2]=7.397376517292135E-5;
		xceref[3]=7.382123863243973E-5;
		xceref[4]=8.926963098749145E-4;
	}
	else
	{
		if ((((grid_points[0]==24)&&(grid_points[1]==24))&&(grid_points[2]==24))&&(no_time_steps==200))
		{
			( * Class)='W';
			dtref=8.0E-4;
			xcrref[0]=112.5590409344;
			xcrref[1]=11.80007595731;
			xcrref[2]=27.10329767846;
			xcrref[3]=24.69174937669;
			xcrref[4]=263.8427874317;
			xceref[0]=4.419655736008;
			xceref[1]=0.4638531260002;
			xceref[2]=1.011551749967;
			xceref[3]=0.9235878729944;
			xceref[4]=10.18045837718;
		}
		else
		{
			if ((((grid_points[0]==64)&&(grid_points[1]==64))&&(grid_points[2]==64))&&(no_time_steps==200))
			{
				( * Class)='A';
				dtref=8.0E-4;
				xcrref[0]=108.06346714637264;
				xcrref[1]=11.319730901220813;
				xcrref[2]=25.974354511582465;
				xcrref[3]=23.66562254467891;
				xcrref[4]=252.78963211748345;
				xceref[0]=4.2348416040525025;
				xceref[1]=0.443902824969957;
				xceref[2]=0.9669248013634565;
				xceref[3]=0.8830206303976548;
				xceref[4]=9.737990177082928;
			}
			else
			{
				if ((((grid_points[0]==102)&&(grid_points[1]==102))&&(grid_points[2]==102))&&(no_time_steps==200))
				{
					( * Class)='B';
					dtref=3.0E-4;
					xcrref[0]=1423.3597229287254;
					xcrref[1]=99.33052259015024;
					xcrref[2]=356.46025644535285;
					xcrref[3]=324.8544795908409;
					xcrref[4]=3270.7541254659363;
					xceref[0]=52.96984714093686;
					xceref[1]=4.463289611567067;
					xceref[2]=13.122573342210174;
					xceref[3]=12.006925323559145;
					xceref[4]=124.59576151035986;
				}
				else
				{
					if ((((grid_points[0]==162)&&(grid_points[1]==162))&&(grid_points[2]==162))&&(no_time_steps==200))
					{
						( * Class)='C';
						dtref=1.0E-4;
						xcrref[0]=6239.8116551764615;
						xcrref[1]=507.93239190423964;
						xcrref[2]=1542.3530093013596;
						xcrref[3]=1330.238792929119;
						xcrref[4]=11604.087428436455;
						xceref[0]=164.62008369091265;
						xceref[1]=11.497107903824313;
						xceref[2]=41.20744620746151;
						xceref[3]=37.08765105969417;
						xceref[4]=362.11053051841265;
					}
					else
					{
						if ((((grid_points[0]==408)&&(grid_points[1]==408))&&(grid_points[2]==408))&&(no_time_steps==250))
						{
							( * Class)='D';
							dtref=2.0E-5;
							xcrref[0]=25331.88551738;
							xcrref[1]=2346.39371698;
							xcrref[2]=6294.554366904;
							xcrref[3]=5352.56537603;
							xcrref[4]=39058.64038618;
							xceref[0]=310.0009377557;
							xceref[1]=24.24086324913;
							xceref[2]=77.82212022645;
							xceref[3]=68.35623860116;
							xceref[4]=606.5737200368;
						}
						else
						{
							if ((((grid_points[0]==1020)&&(grid_points[1]==1020))&&(grid_points[2]==1020))&&(no_time_steps==250))
							{
								( * Class)='E';
								dtref=4.0E-6;
								xcrref[0]=97953.72484517;
								xcrref[1]=9739.814511521;
								xcrref[2]=24676.06342965;
								xcrref[3]=20924.1957286;
								xcrref[4]=139213.8856939;
								xceref[0]=432.7562208414;
								xceref[1]=36.99051964887;
								xceref[2]=108.9845040954;
								xceref[3]=94.62517622043;
								xceref[4]=776.5512765309;
							}
							else
							{
								( * verified)=false;
							}
						}
					}
				}
			}
		}
	}
	//#pragma cetus private(m)
	#pragma loop name verify#2
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		xcrdif[m]=fabs((xcr[m]-xcrref[m])/xcrref[m]);
		xcedif[m]=fabs((xce[m]-xceref[m])/xceref[m]);
	}
	if (( * Class)!='U')
	{
		printf(" Verification being performed for class %c\n",  * Class);
		printf(" accuracy setting for epsilon = %20.13E\n", epsilon);
		( * verified)=(fabs(dt-dtref)<=epsilon);
		if ( ! ( * verified))
		{
			( * Class)='U';
			printf(" DT does not match the reference value of %15.8E\n", dtref);
		}
	}
	else
	{
		printf(" Unknown class\n");
	}
	if (( * Class)!='U')
	{
		printf(" Comparison of RMS-norms of residual\n");
	}
	else
	{
		printf(" RMS-norms of residual\n");
	}
	//#pragma cetus private(m)
	#pragma loop name verify#3
	for (m=0; m<5; m ++ )
	{
		if (( * Class)=='U')
		{
			printf("          %2d%20.13E\n", m+1, xcr[m]);
		}
		else
		{
			if (xcrdif[m]<=epsilon)
			{
				printf("          %2d%20.13E%20.13E%20.13E\n", m+1, xcr[m], xcrref[m], xcrdif[m]);
			}
			else
			{
				( * verified)=false;
				printf(" FAILURE: %2d%20.13E%20.13E%20.13E\n", m+1, xcr[m], xcrref[m], xcrdif[m]);
			}
		}
	}
	if (( * Class)!='U')
	{
		printf(" Comparison of RMS-norms of solution error\n");
	}
	else
	{
		printf(" RMS-norms of solution error\n");
	}
	//#pragma cetus private(m)
	#pragma loop name verify#4
	for (m=0; m<5; m ++ )
	{
		if (( * Class)=='U')
		{
			printf("          %2d%20.13E\n", m+1, xce[m]);
		}
		else
		{
			if (xcedif[m]<=epsilon)
			{
				printf("          %2d%20.13E%20.13E%20.13E\n", m+1, xce[m], xceref[m], xcedif[m]);
			}
			else
			{
				( * verified)=false;
				printf(" FAILURE: %2d%20.13E%20.13E%20.13E\n", m+1, xce[m], xceref[m], xcedif[m]);
			}
		}
	}
	if (( * Class)=='U')
	{
		printf(" No reference values provided\n");
		printf(" No verification performed\n");
	}
	else
	{
		if ( * verified)
		{
			printf(" Verification Successful\n");
		}
		else
		{
			printf(" Verification failed\n");
		}
	}
	return ;
}

void error_norm(double rms[5])
{
	int i, j, k, m, d;
	double xi, eta, zeta, u_exact[5], add;
	//#pragma cetus private(m)
	#pragma loop name error_norm#0
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		rms[m]=0.0;
	}
	//#pragma cetus private(add, eta, i, j, k, m, xi, zeta)
	#pragma loop name error_norm#1
	/* //#pragma cetus reduction(+: rms[m])  */
	for (k=0; k<=(grid_points[2]-1); k ++ )
	{
		zeta=(((double)k)*dnzm1);
		//#pragma cetus private(add, eta, i, j, m, xi)
		#pragma loop name error_norm#1#0
		/* //#pragma cetus reduction(+: rms[m])  */
		for (j=0; j<=(grid_points[1]-1); j ++ )
		{
			eta=(((double)j)*dnym1);
			//#pragma cetus private(add, i, m, xi)
			#pragma loop name error_norm#1#0#0
			/* //#pragma cetus reduction(+: rms[m])  */
			for (i=0; i<=(grid_points[0]-1); i ++ )
			{
				xi=(((double)i)*dnxm1);
				exact_solution(xi, eta, zeta, u_exact);
				//#pragma cetus private(add, m)
				#pragma loop name error_norm#1#0#0#0
				//#pragma cetus parallel
				/*
				Disabled due to low profitability: #pragma omp parallel for private(add, m)
				*/
				for (m=0; m<5; m ++ )
				{
					add=(u[k][j][i][m]-u_exact[m]);
					rms[m]=(rms[m]+(add*add));
				}
			}
		}
	}
	//#pragma cetus private(d, m)
	#pragma loop name error_norm#2
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(d, m)
	*/
	for (m=0; m<5; m ++ )
	{
		//#pragma cetus private(d)
		#pragma loop name error_norm#2#0
		for (d=0; d<3; d ++ )
		{
			rms[m]=(rms[m]/((double)(grid_points[d]-2)));
		}
		rms[m]=sqrt(rms[m]);
	}
	return ;
}

void rhs_norm(double rms[5])
{
	int i, j, k, d, m;
	double add;
	//#pragma cetus private(m)
	#pragma loop name rhs_norm#0
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(m)
	*/
	for (m=0; m<5; m ++ )
	{
		rms[m]=0.0;
	}
	//#pragma cetus parallel
	//#pragma cetus private(add, i, j, k, m)
	#pragma omp parallel private(add, i, j, k, m)
	{
		double * reduce = (double * )malloc(5*sizeof (double));
		int reduce_span_0;
		for (reduce_span_0=0; reduce_span_0<5; reduce_span_0 ++ )
		{
			reduce[reduce_span_0]=0;
		}
		#pragma loop name rhs_norm#1
		//#pragma cetus for
		#pragma omp for
		for (k=1; k<=(grid_points[2]-2); k ++ )
		{
			//#pragma cetus private(add, i, j, m)
			#pragma loop name rhs_norm#1#0
			/* //#pragma cetus reduction(+: rms[m])  */
			for (j=1; j<=(grid_points[1]-2); j ++ )
			{
				//#pragma cetus private(add, i, m)
				#pragma loop name rhs_norm#1#0#0
				/* //#pragma cetus reduction(+: rms[m])  */
				for (i=1; i<=(grid_points[0]-2); i ++ )
				{
					//#pragma cetus private(add, m)
					#pragma loop name rhs_norm#1#0#0#0
					for (m=0; m<5; m ++ )
					{
						add=rhs[k][j][i][m];
						reduce[m]=(reduce[m]+(add*add));
					}
				}
			}
		}
		//#pragma cetus critical
		#pragma omp critical
		{
			for (reduce_span_0=0; reduce_span_0<5; reduce_span_0 ++ )
			{
				rms[reduce_span_0]+=reduce[reduce_span_0];
			}
		}
	}
	//#pragma cetus private(d, m)
	#pragma loop name rhs_norm#2
	//#pragma cetus parallel
	/*
	Disabled due to low profitability: #pragma omp parallel for private(d, m)
	*/
	for (m=0; m<5; m ++ )
	{
		//#pragma cetus private(d)
		#pragma loop name rhs_norm#2#0
		for (d=0; d<3; d ++ )
		{
			rms[m]=(rms[m]/((double)(grid_points[d]-2)));
		}
		rms[m]=sqrt(rms[m]);
	}
	return ;
}

void print_results(char * name, char class, int n1, int n2, int n3, int niter, double t, double mops, char * optype, logical verified, char * npbversion, char * compiletime, char * cs1, char * cs2, char * cs3, char * cs4, char * cs5, char * cs6, char * cs7)
{
	char size[16];
	int j;
	printf("\n\n %s Benchmark Completed.\n", name);
	printf(" Class           =             %12c\n", class);
	if ((n2==0)&&(n3==0))
	{
		if ((name[0]=='E')&&(name[1]=='P'))
		{
			sprintf(size, "%15.0lf", pow(2.0, n1));
			j=14;
			if (size[j]=='.')
			{
				size[j]=' ';
				j -- ;
			}
			size[j+1]='\0';
			printf(" Size            =          %15s\n", size);
		}
		else
		{
			printf(" Size            =             %12d\n", n1);
		}
	}
	else
	{
		printf(" Size            =           %4dx%4dx%4d\n", n1, n2, n3);
	}
	printf(" Iterations      =             %12d\n", niter);
	printf(" Time in seconds =             %12.2lf\n", t);
	printf(" Mop/s total     =          %15.2lf\n", mops);
	printf(" Operation type  = %24s\n", optype);
	if (verified)
	{
		printf(" Verification    =             %12s\n", "SUCCESSFUL");
	}
	else
	{
		printf(" Verification    =             %12s\n", "UNSUCCESSFUL");
	}
	printf(" Version         =             %12s\n", npbversion);
	printf(" Compile date    =             %12s\n", compiletime);
	printf("\n Compile options:\n""    CC           = %s\n", cs1);
	printf("    CLINK        = %s\n", cs2);
	printf("    C_LIB        = %s\n", cs3);
	printf("    C_INC        = %s\n", cs4);
	printf("    CFLAGS       = %s\n", cs5);
	printf("    CLINKFLAGS   = %s\n", cs6);
	printf("    RAND         = %s\n", cs7);
	printf("\n--------------------------------------\n"" Please send all errors/feedbacks to:\n"" Center for Manycore Programming\n"" cmp@aces.snu.ac.kr\n"" http://aces.snu.ac.kr\n""--------------------------------------\n\n");
	return ;
}

static double elapsed_time(void )
{
	double t;
	wtime_( & t);
	return t;
}

static double start[64], elapsed[64];
void timer_clear(int n)
{
	elapsed[n]=0.0;
	return ;
}

void timer_start(int n)
{
	start[n]=elapsed_time();
	return ;
}

void timer_stop(int n)
{
	double t, now;
	now=elapsed_time();
	t=(now-start[n]);
	elapsed[n]+=t;
	return ;
}

double timer_read(int n)
{
	double _ret_val_0;
	_ret_val_0=elapsed[n];
	return _ret_val_0;
}

void wtime_(double * t)
{
	static int sec =  - 1;
	struct timeval tv;
	gettimeofday( & tv, (void * )0);
	if (sec<0)
	{
		sec=tv.tv_sec;
	}
	( * t)=((tv.tv_sec-sec)+(1.0E-6*tv.tv_usec));
	return ;
}
